/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.impl.EntityComparator;
import org.jboss.tools.jsf.model.pv.JSFProjectFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFProjectResourceBundles
extends JSFProjectFolder {
    private static final long serialVersionUID = 6050376048898424153L;
    Iterator<XModelObject> roots = null;

    public void invalidate() {
        if (!this.valid || this.isLoading) {
            return;
        }
        this.valid = false;
        this.fireStructureChanged(3, (Object)this);
    }

    public void set(String name, String value) {
        if ("invalidate".equals(name)) {
            if ("true".equals(value)) {
                this.invalidate();
            }
        } else {
            super.set(name, value);
        }
    }

    public XModelObject[] getTreeChildren() {
        if (this.isLoading || this.valid) {
            return this.treeChildren;
        }
        this.isLoading = true;
        this.valid = true;
        try {
            this.roots = this.getRoots();
            List<XModelObject> list = this.collect(this.roots);
            this.treeChildren = list.toArray(new XModelObject[0]);
        }
        finally {
            this.isLoading = false;
        }
        EntityComparator c = new EntityComparator(new XChild[0]);
        Arrays.sort(this.treeChildren, c);
        return this.treeChildren;
    }

    protected Iterator<XModelObject> getRoots() {
        XModelObject[] ms;
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        FileSystemsImpl fs = (FileSystemsImpl)FileSystemsHelper.getFileSystems((XModel)this.getModel());
        new FileSystemsLoader().updateSrcs((XModelObject)fs);
        XModelObject[] cs = FileSystemsHelper.getFileSystems((XModel)this.getModel()).getChildren("FileSystemFolder");
        int i = 0;
        while (i < cs.length) {
            String n = cs[i].getAttributeValue("name");
            if (n.startsWith("src")) {
                list.add(cs[i]);
            }
            ++i;
        }
        XModelObject web = this.getModel().getByPath("Web");
        XModelObject[] xModelObjectArray = ms = web == null ? new XModelObject[]{} : web.getChildren("WebJSFModule");
        if (ms.length > 0) {
            String s = ms[0].getAttributeValue("src file system");
            if (s == null || s.length() == 0 || "src".equals(s)) {
                return list.iterator();
            }
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                XModelObject r;
                String t = st.nextToken().trim();
                if (t.length() == 0 || "src".equals(t) || (r = FileSystemsHelper.getFileSystem((XModel)this.getModel(), (String)t)) == null) continue;
                list.add(r);
            }
        }
        return list.iterator();
    }

    protected List<XModelObject> collect(Iterator<XModelObject> rs) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        while (rs.hasNext()) {
            this.collect(list, rs.next());
        }
        return list;
    }

    protected void collect(List<XModelObject> l, XModelObject o) {
        if (o.getFileType() == 1) {
            if (this.acceptFile(o)) {
                l.add(o);
            }
        } else if (o.getFileType() > 1) {
            XModelObject[] cs = o.getChildren();
            int i = 0;
            while (i < cs.length) {
                this.collect(l, cs[i]);
                ++i;
            }
        }
    }

    protected boolean acceptFile(XModelObject o) {
        return "FilePROPERTIES".equals(o.getModelEntity().getName());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            if (this.roots == null) {
                this.roots = this.getRoots();
            }
            Iterator<XModelObject> rs = this.roots;
            while (rs.hasNext()) {
                XModelObject r = rs.next();
                Object a = r.getAdapter(adapter);
                if (a == null) continue;
                return a;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public XModelObject getTreeParent(XModelObject object) {
        if (!this.acceptFile(object)) {
            return null;
        }
        return this.isChild(object) ? this : null;
    }
}

