/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.jsf.model.pv.JSFProjectResourceBundles;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.tld.model.TLDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFProjectTagLibs
extends JSFProjectResourceBundles {
    private static final long serialVersionUID = 7805053632320764494L;
    static String TLD_ENTITIES = ".FileTLD_PRO.FileTLD_1_2.FileTLD_2_0.FileTLD_2_1.";

    @Override
    protected Iterator<XModelObject> getRoots() {
        XModelObject fss;
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject r = this.getModel().getByPath("FileSystems/WEB-INF");
        if (r != null) {
            list.add(r);
        }
        if ((fss = this.getModel().getByPath("FileSystems")) == null) {
            return list.iterator();
        }
        XModelObject[] fs = fss.getChildren("FileSystemJar");
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getAttributeValue("name").startsWith("lib-") && (r = fs[i].getChildByPath("META-INF")) != null) {
                list.add(r);
            }
            ++i;
        }
        return list.iterator();
    }

    @Override
    protected List<XModelObject> collect(Iterator<XModelObject> rs) {
        List<XModelObject> list = super.collect(rs);
        List<XModelObject> faceletTaglibs = this.getFaceletTaglibs();
        if (faceletTaglibs != null) {
            for (XModelObject faceletTaglib : faceletTaglibs) {
                if (faceletTaglib.getAttributeValue("uri") == null) continue;
                list.add(faceletTaglib);
            }
        }
        Iterator<XModelObject> it = list.iterator();
        HashSet tlds = new HashSet();
        HashSet<String> facelets = new HashSet<String>();
        while (it.hasNext()) {
            HashSet<String> set;
            XModelObject o = it.next();
            String uri = o.getAttributeValue("uri");
            boolean isFacelet = TLDUtil.isFaceletTaglib((XModelObject)o);
            if (uri != null && uri.length() == 0 && isFacelet) {
                uri = o.getAttributeValue("library-class");
            }
            HashSet<String> hashSet = set = isFacelet ? facelets : tlds;
            if (set.contains(uri)) {
                it.remove();
                continue;
            }
            set.add(uri);
        }
        return list;
    }

    private List<XModelObject> getFaceletTaglibs() {
        XModelObject webxml = this.getModel().getByPath("/web.xml");
        XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.getModel());
        if (webxml == null || webRoot == null) {
            return null;
        }
        XModelObject cp = WebAppHelper.findWebAppContextParam((XModelObject)webxml, (String)"facelets.LIBRARIES");
        if (cp == null) {
            cp = WebAppHelper.findWebAppContextParam((XModelObject)webxml, (String)"javax.faces.FACELETS_LIBRARIES");
        }
        if (cp == null) {
            return null;
        }
        String value = cp.getAttributeValue("param-value");
        if (value == null || value.length() == 0) {
            return null;
        }
        ArrayList<XModelObject> result = new ArrayList<XModelObject>();
        StringTokenizer st = new StringTokenizer(value, ";,");
        while (st.hasMoreTokens()) {
            XModelObject o;
            String path = st.nextToken();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((o = webRoot.getChildByPath(path)) == null) continue;
            result.add(o);
        }
        return result;
    }

    @Override
    protected boolean acceptFile(XModelObject o) {
        if (o.getParent() == null) {
            System.out.println("Null parent " + o);
            return false;
        }
        if ("META-INF".equals(o.getParent().getAttributeValue("name")) && TLDUtil.isFaceletTaglib((XModelObject)o)) {
            return true;
        }
        return JSFProjectTagLibs.isTLDFile(o);
    }

    public static boolean isTLDFile(XModelObject o) {
        String entity = "." + o.getModelEntity().getName();
        return TLD_ENTITIES.indexOf(entity) >= 0;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            XModelObject o = this.getModel().getByPath("FileSystems/WEB-INF");
            return o != null ? o.getAdapter(adapter) : null;
        }
        return super.getAdapter(adapter);
    }
}

