/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.helpers.context;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.FacesProcessImpl;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public class AdoptJSFProjectFinisher {
    protected IImportWebProjectContext context = null;
    protected XModel model = null;
    protected XModelObject web;
    protected XModelObject fss;
    protected String workspace = null;
    protected String srclocation = "";
    protected Map<String, XModelObject> filesystems = new HashMap<String, XModelObject>();

    public void setContext(XModel model, IImportWebProjectContext context) {
        this.context = context;
        this.model = model;
    }

    public void execute() throws XModelException {
        this.filesystems.clear();
        this.workspace = this.context.getWebInfLocation();
        this.fss = this.model.getByPath("FileSystems");
        this.web = this.model.getByPath("Web");
        this.createBuildFileSystem();
        this.createWebInfFileSystem();
        this.createWebXMLFileSystem();
        this.createWebRootFileSystem();
        this.createSrcFileSystems();
        this.createClassesFileSystem();
        this.createLibFileSystems();
        String an = this.context.getApplicationName();
        if (an == null) {
            an = this.context.getProjectName();
        }
        this.fss.setAttributeValue("application name", an);
        this.fss.setModified(true);
        this.appendModules();
        this.modifyWebXML();
        this.model.save();
    }

    private XModelObject getOrCreateFileSystem(String name, String location, boolean req) {
        return this.getOrCreateFileSystem(name, location, null, req, false);
    }

    private XModelObject getOrCreateFileSystem(String name, String location, String info) {
        return this.getOrCreateFileSystem(name, location, info, true, false);
    }

    private XModelObject getOrCreateFileSystem(String name, String location, String info, boolean req, boolean jar) {
        XModelObject fs;
        XModelObject xModelObject = fs = req ? null : this.filesystems.get(location);
        if (fs != null) {
            return fs;
        }
        String entity = !jar ? "FileSystemFolder" : "FileSystemJar";
        fs = this.model.createModelObject(entity, null);
        fs.setAttributeValue("name", name);
        fs.setAttributeValue("location", location);
        if (info != null) {
            fs.setAttributeValue("info", info);
        }
        this.fss.addChild(fs);
        this.filesystems.put(location, fs);
        return fs;
    }

    private void createWebInfFileSystem() {
        this.getOrCreateFileSystem("WEB-INF", XModelConstants.WORKSPACE_REF, true);
    }

    private void createWebXMLFileSystem() {
        File webxml = new File(this.context.getWebXmlLocation());
        String webxmlfolder = webxml.getParent();
        String relative = AdoptJSFProjectFinisher.getRelativePath(this.workspace, webxmlfolder);
        if (relative == null || relative.startsWith("/..")) {
            String loc = relative == null ? webxmlfolder : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
            this.getOrCreateFileSystem("web-xml", loc, true);
            this.web.setAttributeValue("model path", "/" + webxml.getName());
        } else {
            this.web.setAttributeValue("model path", String.valueOf(relative) + "/" + webxml.getName());
        }
    }

    private XModelObject getDefaultModule() {
        XModelObject[] ms = this.context.getModules();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("name").length() == 0) {
                return ms[i];
            }
            ++i;
        }
        return null;
    }

    private void createWebRootFileSystem() {
        XModelObject m = this.getDefaultModule();
        if (m == null) {
            return;
        }
        String loc = AdoptJSFProjectFinisher.getFileSystemLocation(this.workspace, m.getAttributeValue("root"));
        m.setAttributeValue("root file system", "WEB-ROOT");
        this.getOrCreateFileSystem("WEB-ROOT", loc, "Content-Type=Web");
    }

    private void createSrcFileSystems() {
        this.createWebRootSrcFileSystem();
    }

    private void createWebRootSrcFileSystem() {
        String s;
        XModelObject m = this.getDefaultModule();
        String[] srcs = this.context.getExistingSources();
        ArrayList<String> l = new ArrayList<String>();
        if (srcs != null) {
            int i = 0;
            while (i < srcs.length) {
                l.add(srcs[i]);
                ++i;
            }
        }
        if (!l.contains(s = m.getAttributeValue("java src"))) {
            l.add(s);
        }
        srcs = l.toArray(new String[0]);
        String srcAttr = "";
        int j = 0;
        int i = 0;
        while (i < srcs.length) {
            this.srclocation = srcs[i];
            if (this.srclocation.length() != 0) {
                String loc = AdoptJSFProjectFinisher.getFileSystemLocation(this.workspace, this.srclocation);
                String fsn = ++j == 1 ? "src" : "src" + j;
                this.getOrCreateFileSystem(fsn, loc, false);
                if (j > 1) {
                    srcAttr = String.valueOf(srcAttr) + ",";
                }
                srcAttr = String.valueOf(srcAttr) + fsn;
            }
            ++i;
        }
        m.setAttributeValue("src file system", srcAttr);
    }

    private void createLibFileSystems() {
        String lib = this.context.getLibLocation();
        if (lib == null || lib.length() == 0) {
            return;
        }
        File f = new File(lib);
        if (!f.isDirectory()) {
            return;
        }
        String loc = AdoptJSFProjectFinisher.getFileSystemLocation(this.workspace, lib);
        this.getOrCreateFileSystem("lib", loc, true);
        File[] jars = f.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                String n = jars[i].getName();
                this.getOrCreateFileSystem("lib-" + n, String.valueOf(loc) + "/" + n, "hidden=yes", true, true);
                ++i;
            }
        }
    }

    private void createClassesFileSystem() {
        String classes = this.context.getClassesLocation();
        if (classes == null || classes.length() == 0) {
            return;
        }
        if (!new File(classes).isDirectory()) {
            return;
        }
        String loc = AdoptJSFProjectFinisher.getFileSystemLocation(this.workspace, classes);
        this.getOrCreateFileSystem("classes", loc, false);
    }

    private void createBuildFileSystem() {
        String build = this.context.getBuildXmlLocation();
        if (build == null || build.length() == 0) {
            return;
        }
        File f = new File(build);
        if (f.isFile()) {
            f = f.getParentFile();
            build = f.getAbsolutePath();
        }
        if (!new File(build).isDirectory()) {
            return;
        }
        String loc = AdoptJSFProjectFinisher.getFileSystemLocation(this.workspace, build);
        this.getOrCreateFileSystem("build", loc, false);
    }

    protected void appendModules() {
        XModelObject[] ms = this.web.getChildren("WebJSFModule");
        int i = 0;
        while (i < ms.length) {
            ms[i].removeFromParent();
            ++i;
        }
        ms = this.context.getModules();
        i = 0;
        while (i < ms.length) {
            this.web.addChild(ms[i]);
            ++i;
        }
        this.web.setModified(true);
    }

    public static String getRelativePath(String rootpath, String path) {
        return FileUtil.getRelativePath((String)rootpath, (String)path);
    }

    public static String getFileSystemLocation(String rootpath, String path) {
        String relative = AdoptJSFProjectFinisher.getRelativePath(rootpath, path = path.replace('\\', '/'));
        return relative == null ? path : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
    }

    void modifyWebXML() throws XModelException {
        XModelObject facesConfig;
        String servletName;
        XModelObject mapping;
        XModelObject webxml = WebAppHelper.getWebApp((XModel)this.model);
        XModelObject servlet = WebAppHelper.findServlet((XModelObject)webxml, (String)"javax.faces.webapp.FacesServlet", (String)"Faces Config");
        if (servlet == null) {
            servlet = WebAppHelper.findOrCreateServlet((XModelObject)webxml, (String)"javax.faces.webapp.FacesServlet", (String)"Faces Config", (int)-1);
        }
        if ((mapping = WebAppHelper.findServletMapping((XModelObject)webxml, (String)(servletName = servlet.getAttributeValue("servlet-name")))) == null) {
            mapping = WebAppHelper.findOrCreateServletMapping((XModelObject)webxml, (String)servletName);
        }
        if ((facesConfig = this.model.getByPath("/faces-config.xml")) == null) {
            XModelObject webinf = FileSystemsHelper.getWebInf((XModel)this.model);
            boolean isJSF2 = this.isJSF2a();
            if (!isJSF2) {
                try {
                    isJSF2 = this.isJSF2();
                }
                catch (CoreException e) {
                    JSFModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            if (webinf != null && !isJSF2) {
                facesConfig = XModelObjectLoaderUtil.createValidObject((XModel)this.model, (String)"FacesConfig12");
                DefaultCreateHandler.addCreatedObject((XModelObject)webinf, (XModelObject)facesConfig, (int)-1);
                FacesProcessImpl process = (FacesProcessImpl)facesConfig.getChildByPath("process");
                if (process != null) {
                    process.firePrepared();
                }
            }
        }
    }

    boolean isJSF2() throws CoreException {
        IProject project = EclipseResourceUtil.getProject((XModelObject)this.model.getRoot());
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        if (fp == null) {
            return false;
        }
        IProjectFacetVersion v = fp.getProjectFacetVersion(facet);
        if (v == null) {
            return false;
        }
        String vs = v.getVersionString();
        return vs.startsWith("2.");
    }

    boolean isJSF2a() {
        String attr;
        XModelObject fs = this.model.getByPath("FileSystems/lib-jsf-api.jar");
        if (fs == null) {
            return false;
        }
        XModelObject m = fs.getChildByPath("META-INF/MANIFEST.MF");
        if (!(m instanceof FileAnyImpl)) {
            return false;
        }
        String content = ((FileAnyImpl)m).getAsText();
        int i = content.indexOf(attr = "Implementation-Version");
        if (i < 0) {
            return false;
        }
        int j = i += attr.length();
        while (j < content.length()) {
            char ch = content.charAt(j);
            if (Character.isDigit(ch)) {
                return ch > '1';
            }
            ++j;
        }
        return false;
    }
}

