/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.preferences.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessages;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.validation.ContextValidationHelper;
import org.jboss.tools.jst.web.kb.internal.validation.ValidatingProjectSet;
import org.jboss.tools.jst.web.kb.internal.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.kb.internal.validation.ValidatorManager;
import org.jboss.tools.jst.web.kb.validation.IValidatingProjectSet;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELValidator
extends ValidationErrorManager
implements org.jboss.tools.jst.web.kb.validation.IValidator {
    public static final String ID = "org.jboss.tools.jsf.ELValidator";
    private ELResolver[] resolvers;
    protected ELParserFactory mainFactory;
    private IProject currentProject;
    private IResource[] currentSources;
    private IContainer webRootFolder;
    private boolean revalidateUnresolvedELs = false;
    private boolean validateVars = true;
    private static final String JAVA_EXT = "java";
    private boolean enabled = true;

    private boolean isEnabled(IProject project) {
        return JSFSeverityPreferences.shouldValidateEL(project);
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, manager, reporter);
        this.resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)project);
        this.mainFactory = ELParserUtil.getDefaultFactory();
        this.validateVars = "enabled".equals(JSFSeverityPreferences.getInstance().getProjectPreference(this.rootProject, JSFSeverityPreferences.CHECK_VARS));
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, (IValidator)manager, reporter);
        this.webRootFolder = null;
        this.initRevalidationFlag();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        boolean containsJavaOrComponentsXml = false;
        for (IFile file : changedFiles) {
            filesToValidate.add(file);
            if (containsJavaOrComponentsXml) continue;
            String fileName = file.getName().toLowerCase();
            boolean bl = containsJavaOrComponentsXml = fileName.endsWith(".java") || fileName.endsWith(".properties") || fileName.equals("components.xml");
        }
        if (containsJavaOrComponentsXml && this.revalidateUnresolvedELs) {
            Set unnamedResources = this.validationContext.getUnnamedElResources();
            for (IPath path : unnamedResources) {
                IFile file = wsRoot.getFile(path);
                if (!file.exists()) continue;
                filesToValidate.add(file);
            }
        }
        Set elsToValidate = this.validationContext.getElsForValidation(changedFiles, false);
        this.validationContext.removeLinkedEls(filesToValidate);
        for (IFile file : filesToValidate) {
            if (reporter.isCancelled()) continue;
            this.validateFile(file);
        }
        if (this.revalidateUnresolvedELs) {
            for (ELReference el : elsToValidate) {
                if (filesToValidate.contains(el.getResource())) continue;
                this.validateEL(el);
            }
        }
        this.validationContext.clearOldVariableNameForElValidation();
        return this.OK_STATUS;
    }

    private void initRevalidationFlag() {
        String revalidateUnresolvedELsString = JSFSeverityPreferences.getInstance().getProjectPreference(this.rootProject, JSFSeverityPreferences.RE_VALIDATE_UNRESOLVED_EL);
        this.revalidateUnresolvedELs = "enabled".equals(revalidateUnresolvedELsString);
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, (IValidator)manager, reporter);
        this.webRootFolder = null;
        this.initRevalidationFlag();
        Set files = validationHelper.getProjectSetRegisteredFiles();
        for (IFile file : files) {
            if (reporter.isCancelled()) continue;
            if (file.exists()) {
                this.validateFile(file);
                continue;
            }
            this.validationContext.removeUnnamedElResource(file.getFullPath());
        }
        return this.OK_STATUS;
    }

    private boolean shouldFileBeValidated(IFile file) {
        if (!file.isAccessible()) {
            return false;
        }
        IProject project = file.getProject();
        if (this.currentProject == null || !project.equals((Object)this.currentProject)) {
            this.enabled = this.isEnabled(project);
        }
        if (!this.enabled) {
            return false;
        }
        if (!file.isSynchronized(0)) {
            return false;
        }
        if (!project.equals((Object)this.currentProject)) {
            if (this.webRootFolder != null && !project.equals((Object)this.webRootFolder.getProject())) {
                this.webRootFolder = null;
            }
            if (this.webRootFolder == null) {
                IVirtualComponent component;
                IFacetedProject facetedProject = null;
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException e) {
                    JSFModelPlugin.getDefault().logError(JSFValidationMessages.EL_VALIDATOR_ERROR_VALIDATING, e);
                }
                if (facetedProject != null && facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET) != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
                    IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
                    this.webRootFolder = webRootVirtFolder.getUnderlyingFolder();
                }
            }
            this.currentProject = project;
            this.currentSources = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        }
        int i = 0;
        while (i < this.currentSources.length) {
            if (this.currentSources[i].getLocation().isPrefixOf(file.getLocation())) {
                return true;
            }
            ++i;
        }
        if (JAVA_EXT.equalsIgnoreCase(file.getFileExtension())) {
            return false;
        }
        if (this.webRootFolder != null) {
            return this.webRootFolder.getLocation().isPrefixOf(file.getLocation());
        }
        return true;
    }

    private void validateFile(IFile file) {
        if (!this.shouldFileBeValidated(file)) {
            return;
        }
        this.removeAllMessagesFromResource((IResource)file);
        this.displaySubtask(JSFValidationMessages.VALIDATING_EL_FILE, new String[]{file.getProject().getName(), file.getName()});
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (context != null) {
            ELReference[] references = context.getELReferences();
            int i = 0;
            while (i < references.length) {
                if (!references[i].getSyntaxErrors().isEmpty()) {
                    for (SyntaxError error : references[i].getSyntaxErrors()) {
                        IMarker marker = this.addError(JSFValidationMessages.EL_SYNTAX_ERROR, JSFSeverityPreferences.EL_SYNTAX_ERROR, new String[]{error.getProblem()}, 1, references[i].getStartPosition() + error.getPosition(), (IResource)context.getResource());
                        references[i].addMarker(marker);
                    }
                }
                this.validateEL(references[i]);
                ++i;
            }
        }
    }

    private void validateEL(ELReference el) {
        el.deleteMarkers();
        ELExpression[] eLExpressionArray = el.getEl();
        int n = eLExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELExpression expresion = eLExpressionArray[n2];
            this.validateELExpression(el, expresion);
            ++n2;
        }
    }

    private void validateELExpression(ELReference elReference, ELExpression el) {
        if (el == null) {
            return;
        }
        List es = el.getInvocations();
        for (ELInvocationExpression token : es) {
            this.validateElOperand(elReference, token);
        }
    }

    private void validateElOperand(ELReference elReference, ELInvocationExpression operandToken) {
        IMarker marker;
        IFile file = elReference.getResource();
        int documnetOffset = elReference.getStartPosition();
        String operand = operandToken.getText();
        if (operand.trim().length() == 0) {
            return;
        }
        String varName = operand;
        int offsetOfVarName = documnetOffset + operandToken.getFirstToken().getStart();
        int lengthOfVarName = varName.length();
        boolean unresolvedTokenIsVariable = false;
        if (!operand.endsWith(".")) {
            ELResolution resolution = null;
            ELContext context = PageContextFactory.createPageContext((IFile)file);
            if (context == null) {
                context = new SimpleELContext();
                context.setResource(file);
                context.setElResolvers(this.resolvers);
            }
            int maxNumberOfResolvedSegments = -1;
            List vars = null;
            ELContextImpl c = null;
            if (!this.validateVars && context instanceof ELContextImpl) {
                c = (ELContextImpl)context;
                vars = c.getAllVars();
                c.setAllVars(new ArrayList());
            }
            int i = 0;
            while (i < this.resolvers.length) {
                ELResolution elResolution = this.resolvers[i].resolve(context, (ELExpression)operandToken, documnetOffset);
                if (elResolution.isResolved()) {
                    resolution = elResolution;
                    break;
                }
                int number = elResolution.getNumberOfResolvedSegments();
                if (number > maxNumberOfResolvedSegments) {
                    maxNumberOfResolvedSegments = number;
                    resolution = elResolution;
                }
                ++i;
            }
            if (c != null) {
                c.setAllVars(vars);
            }
            if (!resolution.isResolved()) {
                Set<String> names = this.findVariableNames(operandToken);
                for (String name : names) {
                    this.validationContext.addLinkedEl(name, elReference);
                }
            }
            List segments = resolution.getSegments();
            ArrayList usedVariables = new ArrayList();
            for (ELSegment segment : segments) {
                JavaMemberELSegmentImpl javaSegment;
                if (!segment.getVariables().isEmpty()) {
                    usedVariables.addAll(segment.getVariables());
                }
                if (!(segment instanceof JavaMemberELSegmentImpl) || (javaSegment = (JavaMemberELSegmentImpl)segment).getUnpairedGettersOrSetters().isEmpty()) continue;
                TypeInfoCollector.MethodInfo unpairedMethod = (TypeInfoCollector.MethodInfo)javaSegment.getUnpairedGettersOrSetters().values().iterator().next();
                String methodName = unpairedMethod.getName();
                String propertyName = (String)javaSegment.getUnpairedGettersOrSetters().keySet().iterator().next();
                String missingMethodName = JSFValidationMessages.EL_VALIDATOR_SETTER;
                String existedMethodName = JSFValidationMessages.EL_VALIDATOR_GETTER;
                if (methodName.startsWith("s")) {
                    missingMethodName = existedMethodName;
                    existedMethodName = JSFValidationMessages.EL_VALIDATOR_SETTER;
                }
                int startPosition = documnetOffset + operandToken.getStartPosition();
                int length = operandToken.getLength();
                int startPr = operand.indexOf(propertyName);
                if (startPr > -1) {
                    startPosition += startPr;
                    length = propertyName.length();
                }
                IMarker marker2 = this.addError(JSFValidationMessages.UNPAIRED_GETTER_OR_SETTER, JSFSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, new String[]{propertyName, existedMethodName, missingMethodName}, length, startPosition, (IResource)file);
                elReference.addMarker(marker2);
            }
            for (IVariable variable : usedVariables) {
                this.validationContext.addLinkedEl(variable.getName(), elReference);
            }
            if (resolution.isResolved()) {
                return;
            }
            ELSegment segment = resolution.getUnresolvedSegment();
            if (segment == null) {
                JSFModelPlugin.getDefault().logError("No one segment was found in EL " + operand + " in " + file);
                return;
            }
            LexicalToken token = segment.getToken();
            varName = token.getText();
            if (varName == null) {
                return;
            }
            offsetOfVarName = documnetOffset + token.getStart();
            int n = lengthOfVarName = varName == null ? 0 : varName.length();
            if (usedVariables.isEmpty()) {
                unresolvedTokenIsVariable = true;
            }
        }
        if (unresolvedTokenIsVariable) {
            marker = this.addError(JSFValidationMessages.UNKNOWN_EL_VARIABLE_NAME, JSFSeverityPreferences.UNKNOWN_EL_VARIABLE_NAME, new String[]{varName}, lengthOfVarName, offsetOfVarName, (IResource)file);
            elReference.addMarker(marker);
        } else {
            marker = this.addError(JSFValidationMessages.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, JSFSeverityPreferences.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, new String[]{varName}, lengthOfVarName, offsetOfVarName, (IResource)file);
            elReference.addMarker(marker);
        }
    }

    private Set<String> findVariableNames(ELInvocationExpression invocationExpression) {
        HashSet<String> names = new HashSet<String>();
        while (invocationExpression != null) {
            String name;
            if (invocationExpression instanceof ELPropertyInvocation && (name = ((ELPropertyInvocation)invocationExpression).getQualifiedName()) != null) {
                names.add(name);
            }
            invocationExpression = invocationExpression.getLeft();
        }
        return names;
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JSFSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public String getId() {
        return ID;
    }

    public IValidatingProjectSet getValidatingProjects(IProject project) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(project);
        IKbProject kbProject = KbProjectFactory.getKbProject((IProject)project, (boolean)false);
        if (kbProject != null) {
            IValidationContext rootContext = kbProject.getValidationContext();
            return new ValidatingProjectSet(project, projects, rootContext);
        }
        return null;
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.jboss.tools.jsf.jsfnature") && KbProject.checkKBBuilderInstalled((IResource)project);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
            return false;
        }
    }
}

