/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.action.adf;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ClassPathUpdate;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectHelper;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class AddADFSupportHelper {
    static String ORACLE_ADF_LIB_FOLDER_NAME = "OracleADF";
    String adfLibPath;
    XModelObject object;

    public AddADFSupportHelper() {
        try {
            this.adfLibPath = String.valueOf(LibrarySets.getInstance().getLibrarySetsPath()) + "/" + ORACLE_ADF_LIB_FOLDER_NAME;
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void setObject(XModelObject object) {
        this.object = object;
    }

    public boolean isEnabled() {
        if (this.object == null) {
            return false;
        }
        XModel model = this.object.getModel();
        XModelObject fss = FileSystemsHelper.getFileSystems((XModel)model);
        if (fss == null) {
            return false;
        }
        File adfLibFile = new File(this.adfLibPath);
        if (!adfLibFile.isDirectory()) {
            return false;
        }
        File[] fs = adfLibFile.listFiles();
        if (fs == null || fs.length == 0) {
            return false;
        }
        int i = 0;
        while (i < fs.length) {
            String n = fs[i].getName();
            if (n.endsWith(".jar") && fss.getChildByPath("lib-" + n) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void execute() throws InvocationTargetException, InterruptedException {
        ModelPlugin.getDefault().getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)new RunImpl());
    }

    class RunImpl
    implements IRunnableWithProgress {
        RunImpl() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.AddADFSupportHelper_AddADFSupport, 100);
            XModel model = AddADFSupportHelper.this.object.getModel();
            XModelObject fss = FileSystemsHelper.getFileSystems((XModel)model);
            File adfLibFile = new File(AddADFSupportHelper.this.adfLibPath);
            if (!adfLibFile.isDirectory()) {
                monitor.setCanceled(true);
                return;
            }
            File[] fs = adfLibFile.listFiles();
            if (fs == null || fs.length == 0) {
                monitor.setCanceled(true);
                throw new InterruptedException(MessageFormat.format(Messages.AddADFSupportHelper_LibraryIsEmpty, ORACLE_ADF_LIB_FOLDER_NAME));
            }
            String libLocation = NewWebProjectHelper.getLibLocation((XModel)model);
            if (libLocation == null || libLocation.length() == 0) {
                monitor.setCanceled(true);
                throw new InterruptedException(Messages.AddADFSupportHelper_ProjectDoesNotHaveLibFolder);
            }
            String libName = null;
            XModelObject webinf = FileSystemsHelper.getWebInf((XModel)model);
            File webInfDir = ((IResource)webinf.getAdapter(IResource.class)).getLocation().toFile();
            libName = new File(libLocation).getParentFile().equals(webInfDir) ? String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib/" : String.valueOf(libLocation.replace('\\', '/')) + "/";
            int i = 0;
            while (i < fs.length) {
                String jarName = fs[i].getName();
                if (jarName.endsWith(".jar")) {
                    FileUtil.copyFile((File)fs[i], (File)new File(String.valueOf(libLocation) + "/" + jarName), (boolean)true, (boolean)false);
                    String fsName = "lib-" + jarName;
                    if (fss.getChildByPath(fsName) == null) {
                        Properties fsProp = new Properties();
                        fsProp.setProperty("name", fsName);
                        fsProp.setProperty("location", String.valueOf(libName) + jarName);
                        fsProp.setProperty("info", "hidden=yes");
                        XModelObject fsJar = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"FileSystemJar", (Properties)fsProp);
                        if (fss.getChildByPath(fsJar.getPathPart()) == null) {
                            try {
                                DefaultCreateHandler.addCreatedObject((XModelObject)fss, (XModelObject)fsJar, (boolean)false, (int)-1);
                            }
                            catch (XModelException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                }
                ++i;
            }
            monitor.worked(10);
            model.save();
            monitor.worked(10);
            String webRoot = WebProject.getInstance((XModel)model).getWebRootLocation();
            int i2 = 0;
            while (i2 < fs.length) {
                String n = fs[i2].getName();
                if (n.endsWith(".zip")) {
                    try {
                        FileUtil.unzip((File)new File(webRoot), (String)fs[i2].getAbsolutePath());
                    }
                    catch (Exception e) {
                        WebModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                ++i2;
            }
            monitor.worked(30);
            IProject p = EclipseResourceUtil.getProject((XModelObject)model.getRoot());
            if (p != null) {
                try {
                    p.refreshLocal(2, null);
                }
                catch (Exception e) {
                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            monitor.worked(20);
            try {
                model.update();
            }
            catch (XModelException e) {
                throw new InvocationTargetException(e);
            }
            monitor.worked(10);
            try {
                ClassPathUpdate cpu = new ClassPathUpdate();
                cpu.revalidateLibs(model);
            }
            catch (Exception e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            monitor.worked(20);
            monitor.done();
        }
    }
}

