/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultComboBoxValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.preferences.TabbedPreferencesPage;
import org.jboss.tools.common.model.ui.preferences.XMOBasedPreferencesPage;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;

public abstract class WebProjectPreferencesPage
extends TabbedPreferencesPage {
    protected ProjectXMOBasedPreferencesPage newProjectPage;
    protected XMOBasedPreferencesPage importProjectPage;
    private String oldRoot = "";
    private IPropertyEditor defaultRoot;
    private IPropertyEditor selectRoot = null;
    private IValueProvider defaultRootValueProvider = null;
    private IModelPropertyEditorAdapter versionAdapter = null;
    private IWebProjectTemplate template = this.createTemplate();

    public WebProjectPreferencesPage() {
        this.newProjectPage = new ProjectXMOBasedPreferencesPage(this.getPreferenceModel().getByPath(this.getNewProjectOptionPath()));
        this.addPreferencePage((PreferencePage)this.newProjectPage);
        this.importProjectPage = new XMOBasedPreferencesPage(this.getPreferenceModel().getByPath(this.getImportProjectOptionPath()));
        this.addPreferencePage((PreferencePage)this.importProjectPage);
    }

    protected abstract String getNewProjectOptionPath();

    protected abstract String getImportProjectOptionPath();

    protected abstract IWebProjectTemplate createTemplate();

    protected abstract String getVersionAttribute();

    private void updateRootInit() {
        if (this.defaultRoot == null) {
            return;
        }
        boolean active = "no".equals(this.defaultRootValueProvider.getValue());
        this.selectRoot.getFieldEditor(null).setEnabled(active, null);
    }

    private void updateRoot() {
        if (this.defaultRoot == null) {
            return;
        }
        boolean active = "no".equals(this.defaultRootValueProvider.getValue());
        this.selectRoot.getFieldEditor(null).setEnabled(active, null);
        DefaultValueAdapter a = (DefaultValueAdapter)this.selectRoot.getInput();
        boolean auto = a.isAutoStore();
        a.setAutoStore(false);
        if (!active || this.oldRoot.length() == 0) {
            this.oldRoot = a.getStringValue(true);
        }
        String value = active ? this.oldRoot : ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        a.setValue((Object)value);
        a.setAutoStore(auto);
    }

    class DefaultRootChangeListener
    implements PropertyChangeListener {
        DefaultRootChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            WebProjectPreferencesPage.this.updateRoot();
        }
    }

    class ProjectTemplatesListContentProvider
    implements IListContentProvider {
        ProjectTemplatesListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WebProjectPreferencesPage.this.template.getTemplateList(WebProjectPreferencesPage.this.versionAdapter.getValue().toString());
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class ProjectXMOBasedPreferencesPage
    extends XMOBasedPreferencesPage {
        public ProjectXMOBasedPreferencesPage(XModelObject xmo) {
            super(xmo);
            WebProjectPreferencesPage.this.versionAdapter = this.getSupport().getPropertyEditorAdapterByName(WebProjectPreferencesPage.this.getVersionAttribute());
            ((DefaultComboBoxValueAdapter)WebProjectPreferencesPage.this.versionAdapter).setListContentProvider((IListContentProvider)new VersionListContentProvider());
            IModelPropertyEditorAdapter adapter = this.getSupport().getPropertyEditorAdapterByName("Project Template");
            ((DefaultComboBoxValueAdapter)adapter).setListContentProvider((IListContentProvider)new ProjectTemplatesListContentProvider());
        }

        public void initPageProperties() {
            WebProjectPreferencesPage.this.defaultRoot = this.getSupport().getPropertyEditorByName("Use Default Path");
            WebProjectPreferencesPage.this.selectRoot = this.getSupport().getPropertyEditorByName("Projects Root");
            WebProjectPreferencesPage.this.defaultRootValueProvider = (IValueProvider)WebProjectPreferencesPage.this.defaultRoot.getAdapter(IValueProvider.class);
            WebProjectPreferencesPage.this.defaultRootValueProvider.addValueChangeListener((PropertyChangeListener)new DefaultRootChangeListener());
            WebProjectPreferencesPage.this.versionAdapter.addValueChangeListener((PropertyChangeListener)new VersionChangeListener((PropertyChangeListener)this.getSupport().getPropertyEditorByName("Project Template").getFieldEditor(null)));
            WebProjectPreferencesPage.this.updateRootInit();
        }
    }

    class VersionChangeListener
    implements PropertyChangeListener {
        PropertyChangeListener nextListener = null;

        public VersionChangeListener(PropertyChangeListener nextListener) {
            this.nextListener = nextListener;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.nextListener == null) {
                return;
            }
            this.nextListener.propertyChange(new PropertyChangeEvent(evt.getSource(), "IPropertyEditor.listContent", null, null));
        }
    }

    class VersionListContentProvider
    implements IListContentProvider {
        VersionListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WebProjectPreferencesPage.this.template.getVersionList();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

