/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.appregister;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.server.RegistrationHelper;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.appregister.AppRegisterWizardPage;

public class AppRegisterWizard
extends Wizard
implements SpecialWizard {
    Properties p;
    XModelObject object;
    RegisterServerContext registry;
    AppRegisterWizardPage page;

    public AppRegisterWizard() {
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        RegisterServerJob job = new RegisterServerJob();
        job.schedule(100L);
        return true;
    }

    private void register(IProgressMonitor monitor) throws Exception {
        if (monitor != null) {
            monitor.beginTask("", 100);
        }
        if (monitor != null) {
            monitor.worked(5);
        }
        IServer[] servers = this.registry.getTargetServers();
        int step = 70;
        if (monitor != null) {
            monitor.worked(5);
            step /= 2 * servers.length + 1;
        }
        IProject p = EclipseResourceUtil.getProject((XModelObject)this.object);
        String contextRoot = this.registry.getApplicationName();
        if (!contextRoot.equals(ComponentUtilities.getServerContextRoot((IProject)p))) {
            ComponentUtilities.setServerContextRoot((IProject)p, (String)contextRoot);
        }
        int i = 0;
        while (i < servers.length) {
            if (monitor != null) {
                monitor.worked(step);
                monitor.subTask(servers[i].getName());
            }
            RegistrationHelper.register((IProject)p, (IServer)servers[i]);
            if (monitor != null) {
                monitor.worked(step);
            }
            ++i;
        }
        this.object.getModel().changeObjectAttribute(this.object, "application name", this.registry.getApplicationName());
        if (monitor != null) {
            monitor.worked(20);
        }
    }

    public String getWebRootLocation() {
        XModelObject fs = this.object.getModel().getByPath("FileSystems/WEB-ROOT");
        if (!(fs instanceof FileSystemImpl)) {
            return null;
        }
        return ((FileSystemImpl)fs).getAbsoluteLocation();
    }

    public void setObject(Object object) {
        this.p = (Properties)object;
        this.registry = new RegisterServerContext(RegisterServerContext.PROJECT_MODE_EXISTING);
        this.object = (XModelObject)this.p.get("object");
        this.registry.setProjectHandle(EclipseResourceUtil.getProject((XModelObject)this.object));
        this.registry.init();
        this.registry.setNatureIndex(this.p.getProperty("natureIndex"));
        XModelObject web = this.object.getModel().getByPath("Web");
        String servletVersion = web == null ? null : web.getAttributeValue("servlet version");
        this.registry.setServletVersion(servletVersion);
        this.registry.setApplicationName(this.object.getAttributeValue("application name"));
        this.page = new AppRegisterWizardPage(this.registry);
        String n = this.p.getProperty("natureIndex");
        n = n == null ? Messages.AppRegisterWizard_GenericProject : MessageFormat.format(Messages.AppRegisterWizard_Project, n);
        this.page.setTitle(WizardKeys.toDisplayName((String)n));
        this.addPage((IWizardPage)this.page);
    }

    public int execute() {
        Shell shell = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)this);
        dialog.create();
        dialog.getShell().setText(this.p.getProperty("title"));
        dialog.setTitleImage(ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_DEFAULT).createImage(null));
        return dialog.open();
    }

    class RegisterServerJob
    extends Job {
        public RegisterServerJob() {
            super(Messages.AppRegisterWizard_RegisterInServer);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ModelPlugin.getWorkspace().run((IWorkspaceRunnable)new WR(), monitor);
            }
            catch (Exception e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    class WR
    implements IWorkspaceRunnable {
        WR() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                AppRegisterWizard.this.register(monitor);
            }
            catch (Exception e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }
}

