/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.css;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.CSSSelectorValidator;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.FileExtensionFilter;
import org.jboss.tools.jst.web.ui.wizards.css.NewCSSClassWizard;
import org.jboss.tools.jst.web.ui.wizards.messages.WebUIMessages;

public class WizardNewCssClassPage
extends WizardPage
implements ModifyListener {
    private static final String REQUIRED_FIELD_SIGN = "*";
    public static final String CSS_FILE_EXTENSION = "css";
    private NewCSSClassWizard.CSSClassDescription classDescription;
    private static final String[] fileExtensions = new String[]{"css"};
    private int numColumns = 3;
    private Text selectFileText;
    private Text classNameText;

    public WizardNewCssClassPage(NewCSSClassWizard.CSSClassDescription classDescription) {
        super("WizardNewCssClassPage");
        this.classDescription = classDescription;
        this.setTitle(WebUIMessages.WIZARD_TITLE);
        this.setDescription(WebUIMessages.WIZARD_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.numColumns;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label selectFileLabel = new Label(container, 0);
        selectFileLabel.setText(String.valueOf(WebUIMessages.FILE_SELECT_LABEL) + REQUIRED_FIELD_SIGN);
        this.selectFileText = new Text(container, 2052);
        this.selectFileText.setLayoutData((Object)new GridData(768));
        this.selectFileText.setFont(parent.getFont());
        Button selectFileButton = new Button(container, 0);
        selectFileButton.setText(WebUIMessages.FILE_SELECT_BUTTON);
        selectFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(WizardNewCssClassPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.addFilter((ViewerFilter)new FileExtensionFilter(fileExtensions));
                dialog.setTitle(WebUIMessages.FILE_SELECT_DIALOG_TITLE);
                dialog.setMessage(WebUIMessages.FILE_SELECT_DIALOG_MESSAGE);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setAllowMultiple(false);
                dialog.setDoubleClickSelects(true);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection != null && selection.length == 1 && selection[0] instanceof IFile) {
                            return new Status(0, "org.eclipse.ui", 0, "", null);
                        }
                        return new Status(4, "org.eclipse.ui", 4, WebUIMessages.WIZARD_ERROR_FILE_SELECTION, null);
                    }
                });
                if (WizardNewCssClassPage.this.classDescription.getCssFile() != null) {
                    dialog.setInitialSelection((Object)WizardNewCssClassPage.this.classDescription.getCssFile());
                }
                dialog.setEmptyListMessage(WebUIMessages.FILE_SELECT_DIALOG_EMPTY_MESSAGE);
                if (dialog.open() == 0) {
                    WizardNewCssClassPage.this.classDescription.setCssFile((IResource)dialog.getFirstResult());
                    WizardNewCssClassPage.this.selectFileText.setText(WizardNewCssClassPage.this.classDescription.getCssFile().getFullPath().toString());
                }
            }
        });
        Label classNameLabel = new Label(container, 0);
        classNameLabel.setText(String.valueOf(WebUIMessages.CSS_CLASS_NAME_LABEL) + REQUIRED_FIELD_SIGN);
        this.classNameText = new Text(container, 2052);
        this.classNameText.setLayoutData((Object)new GridData(768));
        this.classNameText.setFont(parent.getFont());
        this.classNameText.addModifyListener((ModifyListener)this);
        if (this.classDescription.getCssFile() != null) {
            this.selectFileText.setText(this.classDescription.getCssFile().getFullPath().toString());
        }
        this.selectFileText.addModifyListener((ModifyListener)this);
        this.setControl((Control)container);
    }

    public boolean canFlipToNextPage() {
        return this.classNameText.getText().length() != 0 && this.getCssFile(this.selectFileText.getText()) != null;
    }

    public void modifyText(ModifyEvent e) {
        this.classDescription.setCssClassName(this.classNameText.getText());
        this.classDescription.setCssFile(this.getResource(this.selectFileText.getText()));
        if (this.getCssFile(this.selectFileText.getText()) == null) {
            this.setErrorMessage(WebUIMessages.WIZARD_ERROR_FILE_SELECTION);
        } else if (this.classNameText.getText() == null || this.classNameText.getText().length() == 0) {
            this.setErrorMessage(WebUIMessages.WIZARD_ERROR_EMPTY_CLASSNAME);
        } else if (!CSSSelectorValidator.getInstance().isValidSelector(this.classNameText.getText())) {
            this.setErrorMessage(WebUIMessages.WIZARD_ERROR_INVALID_CLASSNAME);
        } else {
            this.setErrorMessage(null);
        }
        this.getContainer().updateButtons();
    }

    private IFile getCssFile(String path) {
        IResource cssFile = this.getResource(path);
        if (cssFile != null && CSS_FILE_EXTENSION.equals(cssFile.getFileExtension())) {
            return (IFile)cssFile;
        }
        return null;
    }

    private IResource getResource(String path) {
        IResource resource = null;
        if (path != null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        }
        return resource;
    }
}

