/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.palette;

import java.util.Properties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.ui.wizards.palette.ImportTLDPage;

public class ParentGroupComponent {
    Composite composite;
    Button addToExisting;
    CCombo existingGroup;
    Button createNewGroup;
    Text newGroup;
    ImportTLDPage listener;
    String[] items = new String[0];
    String initialItem = null;
    boolean isAdjusting = false;

    public void setListener(ImportTLDPage listener) {
        this.listener = listener;
    }

    public void setItems(String[] items) {
        this.items = items;
        if (this.existingGroup != null && !this.existingGroup.isDisposed()) {
            this.existingGroup.setItems(items);
        }
    }

    public void setInitialItem(String item) {
        this.initialItem = item;
        if (this.initialItem != null && this.existingGroup != null && !this.existingGroup.isDisposed()) {
            this.existingGroup.setText(item);
        }
    }

    public Control createControl(Composite parent) {
        Group group = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        Composite c = new Composite((Composite)group, 0);
        layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(768));
        this.addToExisting = new Button(c, 16);
        GridData gd = new GridData();
        this.addToExisting.setText(WebUIMessages.ADD_TO_EXISTING_GROUP);
        this.addToExisting.setLayoutData((Object)gd);
        this.addToExisting.setSelection(true);
        this.addToExisting.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParentGroupComponent.this.isAdjusting = true;
                ParentGroupComponent.this.createNewGroup.setSelection(!ParentGroupComponent.this.addToExisting.getSelection());
                ParentGroupComponent.this.isAdjusting = false;
                ParentGroupComponent.this.fire();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.existingGroup = new CCombo(c, 2056);
        gd = new GridData(768);
        this.existingGroup.setLayoutData((Object)gd);
        this.existingGroup.setBackground(Display.getDefault().getSystemColor(1));
        this.existingGroup.setItems(this.items);
        if (this.initialItem != null) {
            this.existingGroup.setText(this.initialItem);
        }
        this.existingGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParentGroupComponent.this.fire();
            }
        });
        this.createNewGroup = new Button(c, 16);
        this.createNewGroup.setText(WebUIMessages.CREATE_NEW_GROUP);
        gd = new GridData();
        this.createNewGroup.setLayoutData((Object)gd);
        this.createNewGroup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParentGroupComponent.this.isAdjusting = true;
                ParentGroupComponent.this.addToExisting.setSelection(!ParentGroupComponent.this.createNewGroup.getSelection());
                ParentGroupComponent.this.isAdjusting = false;
                ParentGroupComponent.this.fire();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.newGroup = new Text(c, 2048);
        gd = new GridData(768);
        this.newGroup.setLayoutData((Object)gd);
        this.newGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParentGroupComponent.this.fire();
            }
        });
        this.composite = group;
        return this.composite;
    }

    protected void fire() {
        if (!this.isAdjusting && this.listener != null) {
            this.listener.propertyChange(null);
        }
    }

    public void updateFieldEnablement() {
        if (this.addToExisting == null || this.addToExisting.isDisposed()) {
            return;
        }
        boolean existing = this.addToExisting.getSelection();
        this.newGroup.setEnabled(!existing);
        this.existingGroup.setEnabled(existing);
    }

    public void store(Properties p) {
        p.setProperty("parent group", this.getValue());
    }

    public String getValue() {
        if (this.addToExisting == null || this.addToExisting.isDisposed()) {
            return "";
        }
        boolean existing = this.addToExisting.getSelection();
        String s = existing ? this.existingGroup.getText() : this.newGroup.getText();
        return s == null ? "" : s;
    }
}

