/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateResourcesStep;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateSupport;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.project.CustomCheckboxTreeAndListGroup;

public class AddProjectTemplateResourcesView
extends AbstractSpecialWizardStep {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private CustomCheckboxTreeAndListGroup selectionGroup;
    AddProjectTemplateResourcesStep step;

    public Control createControl(Composite parent) {
        this.step = (AddProjectTemplateResourcesStep)this.support.getProperties().get("ResourcesStep");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        IProject root = ((AddProjectTemplateSupport)this.support).getSelectedProject();
        ArrayList<IProject> input = new ArrayList<IProject>();
        input.add(root);
        this.selectionGroup = new CustomCheckboxTreeAndListGroup(composite, input, this.createTreeContent(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = AddProjectTemplateResourcesView.this.selectionGroup.getListTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
        this.selectionGroup.setTreeChecked(root, true);
        Iterator excluded = this.step.getExcludedResources().iterator();
        while (excluded.hasNext()) {
            IResource o = root.getParent().findMember(excluded.next().toString());
            if (!(o instanceof IFile)) {
                this.selectionGroup.setTreeChecked(o, false);
                continue;
            }
            if (!(o instanceof IResource)) continue;
            this.selectionGroup.initialUncheckListItem(o);
        }
        this.selectionGroup.setExpansions();
        this.selectionGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddProjectTemplateResourcesView.this.validate();
            }
        });
        return composite;
    }

    private ITreeContentProvider createTreeContent() {
        return this.getResourceProvider(14);
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException e) {
                        WebUiPlugin.getPluginLog().logError((Throwable)e);
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    public void validate() {
        String path;
        HashSet<String> list = new HashSet<String>();
        list.clear();
        Iterator it = this.selectionGroup.getAllCheckedTreeItems().iterator();
        while (it.hasNext()) {
            path = ((IResource)it.next()).getFullPath().toString();
            list.add(path);
        }
        it = this.selectionGroup.getAllCheckedListItems();
        while (it.hasNext()) {
            path = ((IResource)it.next()).getFullPath().toString();
            list.add(path);
        }
        this.step.setSelectedResources(list);
        this.wizard.dataChanged(this.validator, new Properties());
    }
}

