/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.jst.web.context.ImportWebDirProjectContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.project.ImportWebProjectWizardPage;

public abstract class ImportWebProjectWizard
extends Wizard
implements IImportWizard {
    public static final String IMPORT_WEB_PROJECT_WIZARD_PROJECT_LOCATION = "IMPORT_WEB_PROJECT_WIZARD_PROJECT_LOCATION";
    public static final String IMPORT_WEB_PROJECT_SELECT_WEB_XML = "IMPORT_WEB_PROJECT_SELECT_WEB_XML";
    public static final String IMPORT_WEB_PROJECT_WIZARD_PROJECT_FOLDERS = "IMPORT_WEB_PROJECT_WIZARD_PROJECT_FOLDERS";
    public static final String IMPORT_WEB_PROJECT_SELECT_PROJECT_FOLDERS = "IMPORT_WEB_PROJECT_SELECT_PROJECT_FOLDERS";
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected ImportWebDirProjectContext context;
    protected String initialName = null;
    protected String initialLocation = null;
    protected ImportWebProjectWizardPage mainPage;

    public ImportWebProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    protected void installMainPage() {
        this.mainPage = new ImportWebProjectWizardPage(this.context);
        this.mainPage.setTitle(WizardKeys.getString((String)IMPORT_WEB_PROJECT_WIZARD_PROJECT_LOCATION));
        this.mainPage.setDescription(WizardKeys.getString((String)IMPORT_WEB_PROJECT_SELECT_WEB_XML));
        this.addPage((IWizardPage)this.mainPage);
    }

    protected void installFoldersPage(WizardPage page) {
        page.setTitle(WizardKeys.getString((String)IMPORT_WEB_PROJECT_WIZARD_PROJECT_FOLDERS));
        page.setDescription(WizardKeys.getString((String)IMPORT_WEB_PROJECT_SELECT_PROJECT_FOLDERS));
        this.addPage((IWizardPage)page);
    }

    public boolean canFinish() {
        if (this.mainPage == null) {
            return false;
        }
        return this.mainPage.isPageComplete() && this.context.canFinish();
    }

    public boolean performFinish() {
        boolean result;
        block7: {
            if (!this.checkOldVersion()) {
                return false;
            }
            result = false;
            if (this.checkServletVersion()) break block7;
            return false;
        }
        try {
            this.context.commitSupportDelta();
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.createOperation());
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            this.updatePerspective();
            BasicNewResourceWizard.selectAndReveal((IResource)this.context.getProjectHandle(), (IWorkbenchWindow)ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
            result = true;
        }
        catch (XModelException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
        catch (CoreException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
        catch (InterruptedException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
        return result;
    }

    protected abstract IRunnableWithProgress createOperation();

    public boolean performCancel() {
        if (this.context == null) {
            return true;
        }
        this.context.rollbackSupportDelta();
        return true;
    }

    protected boolean checkOldVersion() {
        return true;
    }

    public void setInitialName(String s) {
        this.initialName = s;
    }

    public void setInitialLocation(String s) {
        this.initialLocation = s;
    }

    protected void updatePerspective() throws CoreException {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)new ConfigurationElementInternal());
    }

    protected String getFinalPerspective() {
        return "org.jboss.tools.jst.web.ui.WebDevelopmentPerspective";
    }

    private boolean checkServletVersion() throws XModelException {
        if (this.context.isServletVersionConsistentToWebXML()) {
            return true;
        }
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        String servletVersion = this.context.getServletVersion();
        String message = NLS.bind((String)WebUIMessages.SERVLET_VERSION_ISNOT_CONSISTENT_WITH_WEBXML_VERSION, (Object)servletVersion);
        Properties p = new Properties();
        p.setProperty("title", WebUIMessages.WARNING);
        p.setProperty("message", message);
        String checkBoxMessage = NLS.bind((String)WebUIMessages.SAVE_OLD_SERVLET, (Object)this.context.getWebXMLVersion());
        p.setProperty("checkboxMessage", checkBoxMessage);
        p.put("checked", Boolean.TRUE);
        p.put("buttons", new String[]{WebUIMessages.YES, WebUIMessages.NO, WebUIMessages.CANCEL});
        boolean b = d.openConfirm(p);
        int q = p.containsKey("returnCode") ? (Integer)p.get("returnCode") : (b ? 0 : -1);
        boolean backup = (Boolean)p.get("checked");
        if (q == 0) {
            this.context.convertWebXML(backup);
        }
        return q == 0 || q == 1;
    }

    private class ConfigurationElementInternal
    implements IConfigurationElement {
        private ConfigurationElementInternal() {
        }

        public Object getParent() {
            return null;
        }

        public String getAttribute(String name) {
            return "finalPerspective".equals(name) ? ImportWebProjectWizard.this.getFinalPerspective() : null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getAttributeAsIs(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String[] getAttributeNames() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IConfigurationElement[] getChildren() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IConfigurationElement[] getChildren(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public IExtension getDeclaringExtension() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getValue() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getValueAsIs() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Class loadExtensionClass(String propertyName) throws CoreException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

