/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceContentProvider
implements ITreeContentProvider {
    public static int FOLDER = 1;
    public static int FILE = 2;
    int type;
    FileFilter filter = new FileFilterImpl();
    File root = null;

    public ResourceContentProvider(int type) {
        this.type = type;
    }

    public Object[] getChildren(Object parentElement) {
        File f = (File)parentElement;
        return f.listFiles(this.filter);
    }

    public Object getParent(Object element) {
        if (this.root == null) {
            return null;
        }
        if (this.root == element || this.root.equals(element)) {
            return null;
        }
        File f = (File)element;
        if (f.getAbsolutePath().length() < this.root.getAbsolutePath().length()) {
            return null;
        }
        return f.getParentFile();
    }

    public boolean hasChildren(Object element) {
        File f = (File)element;
        if (!f.isDirectory()) {
            return false;
        }
        File[] fs = f.listFiles(this.filter);
        return fs != null && fs.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof File) {
            return this.getChildren(inputElement);
        }
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return null;
    }

    public void dispose() {
        this.root = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof List) {
            List list = (List)newInput;
            newInput = list.isEmpty() ? null : (File)list.get(0);
        }
        File newRoot = (File)newInput;
        if (this.root != null && !this.root.equals(newRoot)) {
            this.root = newRoot;
            if (viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                viewer.refresh();
            }
        } else {
            this.root = newRoot;
        }
    }

    class FileFilterImpl
    implements FileFilter {
        FileFilterImpl() {
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return (ResourceContentProvider.this.type & FOLDER) != 0;
            }
            if (pathname.isFile()) {
                return (ResourceContentProvider.this.type & FILE) != 0;
            }
            return false;
        }
    }
}

