/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;

public class ResourceLabelProvider
extends LabelProvider {
    static XModel model;
    static XModelObject folder;
    static NavigatorLabelProvider labelProvider;
    static Map images;

    static void init() {
        if (model != null) {
            return;
        }
        model = PreferenceModelUtilities.getPreferenceModel();
        folder = model.createModelObject("FileFolder", null);
        labelProvider = new NavigatorLabelProvider();
        images = new HashMap();
    }

    public ResourceLabelProvider() {
        ResourceLabelProvider.init();
    }

    public String getText(Object element) {
        if (element instanceof File) {
            return ((File)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            File f = (File)element;
            if (f.isDirectory()) {
                return labelProvider.getImage((Object)folder);
            }
            String entity = this.getEntity(f.getName());
            return this.getImageInternal(entity);
        }
        return null;
    }

    Image getImageInternal(String entity) {
        Image image = (Image)images.get(entity);
        if (image == null) {
            XModelObject o = model.createModelObject(entity, null);
            if (o == null) {
                o = model.createModelObject("FileTXT", null);
            }
            if (o == null) {
                o = folder;
            }
            if ((image = labelProvider.getImage((Object)o)) != null) {
                images.put(entity, image);
            }
        }
        return image;
    }

    String getEntity(String filename) {
        String ext;
        int i = filename.lastIndexOf(46);
        String string = ext = i < 0 ? "" : filename.substring(i + 1);
        if (ext.equals("xml")) {
            if (filename.equals("web.xml")) {
                return "FileWebApp";
            }
            if (filename.startsWith("faces-")) {
                return "FacesConfig11";
            }
            if (filename.startsWith("struts-")) {
                return "StrutsConfig11";
            }
            return "FileXML";
        }
        String entity = model.getEntityRecognizer().getEntityName(new EntityRecognizerContext(filename, ext, null));
        if (entity == null) {
            entity = "FileTXT";
        }
        return entity;
    }
}

