/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.css.common;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jboss.tools.jst.css.CssPlugin;
import org.jboss.tools.jst.css.common.CSSStyleManager;
import org.jboss.tools.jst.css.common.ICSSViewListner;
import org.jboss.tools.jst.css.common.StyleContainer;

public class CSSStyleListener
implements ISelectionListener,
INodeAdapter,
IPartListener {
    private static CSSStyleListener instance;
    private ListenerList listeners = new ListenerList();
    private CSSStyleManager styleManager = new CSSStyleManager();
    private StyleContainer currentStyle;
    private IWorkbenchPart currentPart;

    private CSSStyleListener() {
    }

    public static synchronized CSSStyleListener getInstance() {
        if (instance == null) {
            instance = new CSSStyleListener();
        }
        return instance;
    }

    public void addSelectionListener(ICSSViewListner listener) {
        if (this.listeners.size() == 0) {
            this.startListening();
        }
        this.listeners.add((Object)listener);
    }

    public void removeSelectionListener(ICSSViewListner listener) {
        this.listeners.remove((Object)listener);
        if (this.listeners.size() == 0) {
            this.stopListening();
        }
    }

    private void startListening() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void stopListening() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        StyleContainer newStyle = this.styleManager.recognizeCSSStyle(selection);
        if (this.isImportant(part) && (this.currentStyle == null || !this.currentStyle.equals(newStyle))) {
            this.disconnect(this.currentStyle);
            this.connect(newStyle);
            this.currentStyle = newStyle;
            StructuredSelection selectionToLiteners = null;
            selectionToLiteners = newStyle != null && newStyle.isValid() ? new StructuredSelection((Object)newStyle) : StructuredSelection.EMPTY;
            Object[] array = this.listeners.getListeners();
            int i = 0;
            while (i < array.length) {
                ICSSViewListner l = (ICSSViewListner)array[i];
                if (part != null && l != this.currentPart && selection != null) {
                    try {
                        l.selectionChanged(part, (ISelection)selectionToLiteners);
                    }
                    catch (Exception e) {
                        CssPlugin.log(e.getLocalizedMessage());
                    }
                }
                ++i;
            }
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart || part instanceof ContentOutline;
    }

    private void connect(StyleContainer style) {
        if (style != null) {
            style.addNodeListener(this);
        }
    }

    private void disconnect(StyleContainer style) {
        if (style != null) {
            style.removeNodelListener(this);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(CSSStyleListener.class);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            ICSSViewListner l = (ICSSViewListner)array[i];
            if (this.currentPart != l) {
                try {
                    l.styleChanged(this.currentStyle);
                }
                catch (Exception e) {
                    CssPlugin.log(e.getLocalizedMessage());
                }
            }
            ++i;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.currentPart = part;
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            ICSSViewListner l = (ICSSViewListner)array[i];
            if (l instanceof IPartListener) {
                try {
                    ((IPartListener)l).partActivated(part);
                }
                catch (Exception e) {
                    CssPlugin.log(e.getLocalizedMessage());
                }
            }
            ++i;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

