/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.css.common;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.jboss.tools.jst.css.common.CSSStyleRuleContainer;
import org.jboss.tools.jst.css.common.StyleAttribyteContainer;
import org.jboss.tools.jst.css.common.StyleContainer;
import org.jboss.tools.jst.css.common.StyleElementRuleContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class CSSStyleManager {
    public static final String STYLE_TAG_NAME = "style";
    public static final String STYLE_ATTRIBUTE_NAME = "style";

    public StyleContainer recognizeCSSStyle(ISelection selection) {
        StyleContainer container = null;
        if (selection instanceof IStructuredSelection) {
            Text styleText;
            Node parentNode;
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof ICSSNode) {
                CSSStyleRule styleRule = this.getStyleRule((ICSSNode)selectedObject);
                if (styleRule != null) {
                    container = new CSSStyleRuleContainer(styleRule);
                }
            } else if (selectedObject instanceof Element || selectedObject instanceof Attr) {
                Element selectedElement = null;
                selectedElement = selectedObject instanceof Attr ? ((Attr)selectedObject).getOwnerElement() : (Element)selectedObject;
                if (this.isSuitableElement(selectedElement)) {
                    container = new StyleAttribyteContainer(selectedElement);
                }
            } else if (selectedObject instanceof Text && selection instanceof ITextSelection && (parentNode = (styleText = (Text)selectedObject).getParentNode()) != null && "style".equalsIgnoreCase(parentNode.getNodeName())) {
                int offset = this.getRelationalOffset(styleText, ((ITextSelection)selection).getOffset());
                CSSStyleSheet sheet = this.getSheet(parentNode);
                ICSSNode node = this.getNode(sheet, offset);
                CSSStyleRule styleRule = this.getStyleRule(node);
                if (styleRule != null) {
                    container = new StyleElementRuleContainer(styleText, styleRule);
                }
            }
        }
        return container;
    }

    private CSSStyleSheet getSheet(Node styleContainer) {
        INodeNotifier notifier;
        IStyleSheetAdapter adapter;
        if (styleContainer instanceof INodeNotifier && (adapter = (IStyleSheetAdapter)(notifier = (INodeNotifier)styleContainer).getAdapterFor(IStyleSheetAdapter.class)) != null) {
            return (CSSStyleSheet)adapter.getSheet();
        }
        return null;
    }

    private ICSSNode getNode(CSSStyleSheet sheet, int offset) {
        ICSSModel model = ((ICSSDocument)sheet).getModel();
        if (model != null) {
            return (ICSSNode)model.getIndexedRegion(offset);
        }
        return null;
    }

    private boolean isSuitableElement(Element element) {
        return element instanceof ElementCSSInlineStyle && CSSStyleManager.isAttributeAvailable(element, "style");
    }

    private CSSStyleRule getStyleRule(ICSSNode node) {
        while (node != null) {
            if (node instanceof CSSStyleRule) {
                return (CSSStyleRule)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private int getRelationalOffset(Node basicNode, int absoluteOffset) {
        return absoluteOffset - ((IndexedRegion)basicNode).getStartOffset();
    }

    private static boolean isAttributeAvailable(Element element, String attrName) {
        CMNamedNodeMap map;
        CMElementDeclaration decl;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        return modelQuery != null && (decl = modelQuery.getCMElementDeclaration(element)) != null && (CMAttributeDeclaration)(map = decl.getAttributes()).getNamedItem(attrName) != null;
    }
}

