/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.css.properties;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.jst.css.common.StyleContainer;
import org.jboss.tools.jst.css.view.CSSEditorView;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.StyleAttributes;

public class CSSPropertyPage
extends TabbedPropertySheetPage
implements IChangeListener {
    private DataBindingContext bindingContext = new DataBindingContext();
    private StyleAttributes styleAttributes = new StyleAttributes();
    private CSSEditorView part;
    private Object selectedObject;

    public CSSPropertyPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, CSSEditorView part) {
        super(tabbedPropertySheetPageContributor);
        this.styleAttributes.addChangeListener((IChangeListener)this);
        this.part = part;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return CSSPropertyPage.this.getCurrentSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.part != part && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object newSelectedObject = structuredSelection.getFirstElement();
            if (this.selectedObject == null || !this.selectedObject.equals(newSelectedObject)) {
                super.selectionChanged(part, selection);
            }
            this.selectedObject = newSelectedObject;
            this.update();
        }
    }

    public void update() {
        if (this.selectedObject instanceof StyleContainer) {
            this.getStyleAttributes().removeChangeListener((IChangeListener)this);
            this.getStyleAttributes().setStyleProperties(((StyleContainer)this.selectedObject).getStyleAttributes());
            this.getStyleAttributes().addChangeListener((IChangeListener)this);
        }
    }

    public void handleChange(ChangeEvent event) {
        if (this.selectedObject instanceof StyleContainer) {
            ((StyleContainer)this.selectedObject).applyStyleAttributes(this.getStyleAttributes().getStyleProperties());
        }
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public StyleAttributes getStyleAttributes() {
        return this.styleAttributes;
    }

    public ISelection getCurrentSelection() {
        Object currentSelectedObject = this.selectedObject;
        if (this.selectedObject instanceof StyleContainer) {
            currentSelectedObject = ((StyleContainer)this.selectedObject).getStyleObject();
        }
        return currentSelectedObject != null ? new StructuredSelection(currentSelectedObject) : StructuredSelection.EMPTY;
    }
}

