/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.browser;

import java.text.MessageFormat;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.browser.BrowserHistory;
import org.jboss.tools.jst.web.browser.IBrowserContext;
import org.jboss.tools.jst.web.browser.IPathSource;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;

public abstract class AbstractBrowserContext
implements IBrowserContext {
    IPathSource[] sources = new IPathSource[0];
    BrowserHistory history = new BrowserHistory(this);
    public XModelObject lastRunObject = null;
    long lastRunObjectTimeStamp = -1L;
    protected String url = null;
    public String lastRunUrl = null;
    public Object monitor = new Object();
    protected boolean inited = false;

    public void addPathSource(IPathSource s) {
        IPathSource[] ss = new IPathSource[this.sources.length + 1];
        System.arraycopy(this.sources, 0, ss, 0, this.sources.length);
        ss[this.sources.length] = s;
        this.sources = ss;
    }

    public abstract String getModelActionPath();

    public void init() {
    }

    public void execute(XModelObject object) throws XModelException {
        this.setLastRunObject(object);
        if (this.url == null) {
            throw new XModelException(MessageFormat.format(WebUIMessages.AbstractBrowserContext_CannotOpen, DefaultCreateHandler.title((XModelObject)object, (boolean)false)));
        }
        this.doExecute(this.lastRunUrl);
        if (this.lastRunUrl.equals(this.url)) {
            this.history.add(this.lastRunObject, this.url);
        } else {
            this.history.add(this.lastRunUrl);
        }
    }

    protected abstract void doExecute(String var1) throws XModelException;

    boolean isLastRunObjectUpToDate(XModelObject o) {
        long ts;
        if (o == null) {
            return this.lastRunObject == null;
        }
        if (this.url == null) {
            return false;
        }
        String prefix = this.getBrowserPrefix(o.getModel());
        if (prefix == null) {
            return false;
        }
        if (!this.url.startsWith(prefix) || !this.url.equals(this.lastRunUrl)) {
            return false;
        }
        if (o != this.lastRunObject) {
            return false;
        }
        long l = ts = o == null ? -1L : o.getTimeStamp();
        return this.lastRunObjectTimeStamp == ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastRunObject(XModelObject o) {
        if (this.isLastRunObjectUpToDate(o)) {
            return;
        }
        this.lastRunObject = o;
        long l = this.lastRunObjectTimeStamp = o == null ? -1L : o.getTimeStamp();
        if (o == null) {
            this.url = null;
            if (this.lastRunUrl != null && !this.history.isJustUrl(this.lastRunUrl)) {
                this.lastRunUrl = null;
            }
        } else {
            this.updateRunPath();
        }
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    public String getLastRunURL() {
        return this.lastRunUrl;
    }

    public String[] getHistory() {
        return this.history.items();
    }

    private void updateRunPath() {
        this.lastRunUrl = this.url = this.computeURL(this.lastRunObject);
    }

    public String computeURL(XModelObject o) {
        if (o == null || !o.isActive()) {
            return null;
        }
        if (!this.inited) {
            this.init();
        }
        String u = null;
        int i = 0;
        while (i < this.sources.length && u == null) {
            u = this.sources[i].computeURL(o);
            ++i;
        }
        return u;
    }

    public void activateJustUrl(String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        this.lastRunUrl = url;
        this.history.add(url);
    }

    public XModelObject activateItem(String url) {
        this.history.validate();
        XModelObject o = this.history.getRunObject(url);
        if (o == null) {
            return null;
        }
        this.setLastRunObject(o);
        return this.lastRunObject;
    }

    public boolean isJustUrl(String url) {
        return url != null && this.history.isJustUrl(url);
    }

    public abstract void runJustUrl();

    public XModelObject activateModel(XModel model) {
        String[] items = this.history.getAllItems();
        int i = 0;
        while (i < items.length) {
            XModelObject o = this.history.getRunObject(items[i]);
            if (o != null && o.getModel() == model) {
                this.activateItem(items[i]);
                return o;
            }
            ++i;
        }
        XModelObject o = model.getRoot();
        this.setLastRunObject(o);
        return o;
    }

    public void revalidate() {
        this.lastRunObjectTimeStamp = -2L;
        this.setLastRunObject(this.lastRunObject);
    }
}

