/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.context;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.WebModuleImpl;

public abstract class AdoptWebProjectContext {
    protected SpecialWizardSupport support = null;
    protected String webinfLocation = null;
    protected String webxmlLocation = null;
    protected XModelObject[] modules = new XModelObject[0];
    protected String applicationName;
    protected String libPath;
    protected String classesPath;
    protected String buildPath;

    public void setSupport(SpecialWizardSupport support) {
        this.support = support;
    }

    public void reset() {
        this.webinfLocation = null;
        this.webxmlLocation = null;
        this.modules = new XModelObject[0];
    }

    public String getApplicationName() {
        return this.support.getAttributeValue(1, "name");
    }

    public String getLibPath() {
        return this.support.getAttributeValue(3, "lib");
    }

    public String getClassesPath() {
        return this.support.getAttributeValue(3, "classes");
    }

    public String getBuildPath() {
        return this.support.getAttributeValue(3, "build");
    }

    public String getWebInfLocation() {
        return this.webinfLocation;
    }

    public String getWebXMLLocation() {
        return this.webxmlLocation;
    }

    public XModelObject[] getModules() {
        return this.modules;
    }

    public String getWebRootPath() {
        String result = null;
        int i = 0;
        while (i < this.modules.length && result == null) {
            if ("<default>".equals(this.getModuleName(this.modules[i]))) {
                result = this.modules[i].getAttributeValue("root");
            }
            ++i;
        }
        return result;
    }

    public void setWebInfLocation(String location) {
        if ((location = location.replace('\\', '/')).equals(this.webinfLocation)) {
            return;
        }
        this.webinfLocation = location;
        File f = new File(location);
        if (f.getName().equals("WEB-INF")) {
            this.support.setAttributeValue(1, "name", f.getParentFile().getName());
            File w = new File(f, "web.xml");
            if (w.isFile()) {
                this.support.setAttributeValue(1, "web.xml location", w.getAbsolutePath().replace('\\', '/'));
            }
            if ((w = new File(f, "classes")).isDirectory()) {
                this.support.setAttributeValue(3, "classes", w.getAbsolutePath().replace('\\', '/'));
            }
            if ((w = new File(f, "lib")).isDirectory()) {
                this.support.setAttributeValue(3, "lib", w.getAbsolutePath().replace('\\', '/'));
            }
        } else {
            this.support.setAttributeValue(1, "web.xml location", "");
        }
    }

    public void setWebXMLLocation(String location) throws XModelException {
        if ((location = location.replace('\\', '/')).equals(this.webxmlLocation)) {
            return;
        }
        this.modules = new XModelObject[0];
        File f = new File(location);
        if (!f.isFile()) {
            throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_FileDoesNotExist, location));
        }
        String body = FileUtil.readFile((File)f);
        String entity = this.support.getTarget().getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext("xml", body));
        if (entity == null || !entity.startsWith("FileWebApp")) {
            throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_FileNotRecognizedAsWebDescriptor, location));
        }
        XModelObject webxml = null;
        webxml = this.support.getTarget().getModel().createModelObject(entity, null);
        webxml.setAttributeValue("name", "web");
        XModelObjectLoaderUtil.setTempBody((XModelObject)webxml, (String)body);
        XModelObjectLoaderUtil.getObjectLoader((XModelObject)webxml).load(webxml);
        webxml.getChildren();
        if ("yes".equals(webxml.getAttributeValue("isIncorrect"))) {
            throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_WebDescriptorFileIsCorrupted, location));
        }
        this.webxmlLocation = location;
        this.modules = this.createModulesInfo(webxml, new File(this.webinfLocation));
    }

    public abstract XModelObject[] createModulesInfo(XModelObject var1, File var2);

    protected String getWebModuleEntity() {
        return "JstWebModule";
    }

    public XModelObject createModuleInfo(XModel model, String name, String uri, File webinf) {
        return this.createModuleInfo(model, name, uri, webinf, false);
    }

    public XModelObject createModuleInfo(XModel model, String name, String uri, File webinf, boolean create) {
        String loc = webinf.getAbsolutePath().replace('\\', '/');
        String parent = webinf.getParentFile().getAbsolutePath().replace('\\', '/');
        if (parent.indexOf("..") >= 0) {
            try {
                parent = new File(parent).getCanonicalPath().replace('\\', '/');
            }
            catch (IOException t) {
                WebModelPlugin.getPluginLog().logError((Throwable)t);
            }
        }
        Properties p = new Properties();
        p.setProperty("name", name);
        p.setProperty("URI", uri);
        String path = this.getPathOnDisk(parent, webinf.getName(), uri);
        if (path != null) {
            p.setProperty("path on disk", path);
        }
        if (name.length() == 0) {
            String src;
            if ("WEB-INF".equals(webinf.getName()) || path != null) {
                p.setProperty("root", parent);
            }
            if ((src = this.guessSrc(loc, false)) != null) {
                p.setProperty("java src", src);
            }
        } else {
            String modulesrc;
            String modulepath = String.valueOf(parent) + name;
            File mf = new File(modulepath);
            if (mf.isDirectory() || create && !mf.exists()) {
                p.setProperty("root", modulepath);
            }
            if (new File(modulesrc = String.valueOf(modulepath) + "/src").isDirectory()) {
                p.setProperty("java src", modulesrc);
            } else {
                String src = this.guessSrc(loc, create);
                if (src != null) {
                    p.setProperty("java src", src);
                }
            }
        }
        XModelObject o = model.createModelObject(this.getWebModuleEntity(), p);
        if (uri.indexOf(44) >= 0 && o instanceof WebModuleImpl) {
            ((WebModuleImpl)o).setURI(uri);
            StringTokenizer st = new StringTokenizer(uri, ",");
            if (st.hasMoreTokens()) {
                String t = st.nextToken().trim();
                path = this.getPathOnDisk(parent, webinf.getName(), t);
                if (path != null) {
                    o.setAttributeValue("path on disk", path);
                }
                while (st.hasMoreTokens()) {
                    t = st.nextToken().trim();
                    String cp = t.replace('/', '#');
                    XModelObject c = o.getChildByPath(cp);
                    path = this.getPathOnDisk(parent, webinf.getName(), t);
                    if (c == null || path == null) continue;
                    c.setAttributeValue("path on disk", path);
                }
            }
        }
        return o;
    }

    private String getPathOnDisk(String parent, String win, String uri) {
        String path = String.valueOf(parent) + uri;
        if (new File(path).isFile()) {
            return path;
        }
        if (uri.startsWith("/WEB-INF/") ? new File(path = String.valueOf(parent) + "/" + win + uri.substring(8)).isFile() : uri.startsWith("WEB-INF/") && new File(path = String.valueOf(parent) + "/" + win + uri.substring(7)).isFile()) {
            return path;
        }
        return null;
    }

    protected String guessSrc(String loc, boolean create) {
        String src = String.valueOf(loc) + "/src";
        File sf = new File(src);
        if (sf.isDirectory() || create && !sf.exists()) {
            return src;
        }
        src = String.valueOf(loc) + "/../../JavaSource";
        sf = new File(src);
        if (sf.isDirectory()) {
            try {
                return sf.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
                return src;
            }
        }
        return null;
    }

    public void validateModules() throws XModelException {
        int i = 0;
        while (i < this.modules.length) {
            String n = this.getModuleName(this.modules[i]);
            String uri = this.modules[i].getAttributeValue("URI");
            String path = this.modules[i].getAttributeValue("path on disk");
            if (path.length() == 0) {
                throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_PathIsNotSet, uri));
            }
            if (!new File(path).isFile()) {
                throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_PathDoesNotExist, path, uri));
            }
            path = this.modules[i].getAttributeValue("root");
            if (path.length() == 0) {
                throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_RootIsNotSet, n));
            }
            if (!new File(path).isDirectory()) {
                throw new XModelException(MessageFormat.format(WebUIMessages.AdoptWebProjectContext_RootDoesNotExist, path, n));
            }
            ++i;
        }
    }

    private String getModuleName(XModelObject module) {
        String n = module.getAttributeValue("name");
        return n.length() == 0 ? "<default>" : n;
    }
}

