/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.context;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public abstract class ImportWebProjectContext
implements IImportWebProjectContext {
    protected XModelObject target;
    protected long webXMLTimeStamp = -1L;
    protected String webXmlLocation = null;
    protected String projectName;
    protected String classesLocation = "";
    protected String libLocation = "";
    protected String buildXmlLocation = "";
    protected String webInfLocation;
    protected XModelObject webxml = null;
    protected XModelObject[] modules = new XModelObject[0];
    protected XModelObject[] allmodules = new XModelObject[0];
    protected String[] existingSources = new String[0];
    RegisterServerContext registry = new RegisterServerContext(RegisterServerContext.PROJECT_MODE_IMPORT);
    protected boolean addLibraries = false;
    protected String servletVersion = null;
    protected String templateVersion = null;
    protected boolean isLinkingToProjectOutsideWorkspace = true;

    public void setTarget(XModelObject target) {
        this.target = target;
    }

    public XModelObject getTarget() {
        return this.target;
    }

    public RegisterServerContext getRegisterServerContext() {
        return this.registry;
    }

    public String getWebXmlLocation() {
        return this.webXmlLocation;
    }

    public XModelObject[] getModules() {
        return this.modules;
    }

    public XModelObject[] getAllModules() {
        return this.allmodules;
    }

    protected void createAllModules() {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] os = this.getModules();
        int i = 0;
        while (i < os.length) {
            list.add(os[i]);
            XModelObject[] cs = os[i].getChildren();
            int k = 0;
            while (k < cs.length) {
                list.add(cs[k]);
                ++k;
            }
            ++i;
        }
        this.allmodules = list.toArray(new XModelObject[0]);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String value) {
        this.projectName = value;
        this.registry.setProjectHandle(this.getProjectHandle());
    }

    public IProject getProjectHandle() {
        String n = this.getProjectName();
        if (n == null || n.length() == 0) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.projectName, 4);
        if (!nameStatus.isOK()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(n);
    }

    public String getApplicationName() {
        return this.registry.getApplicationName();
    }

    public void setApplicationName(String value) {
        this.registry.setApplicationName(value);
    }

    public String getClassesLocation() {
        return this.classesLocation;
    }

    public void setClassesLocation(String value) {
        this.classesLocation = value;
    }

    public String getLibLocation() {
        if ((this.libLocation == null || this.libLocation.trim().length() == 0) && this.addLibraries) {
            return this.getDefaultLibLocation();
        }
        return this.libLocation;
    }

    public void setLibLocation(String value) {
        this.libLocation = value;
    }

    public String getDefaultLibLocation() {
        return this.webInfLocation == null ? "" : String.valueOf(this.webInfLocation) + "/lib";
    }

    public String getBuildXmlLocation() {
        return this.buildXmlLocation;
    }

    public void setBuildXmlLocation(String value) {
        this.buildXmlLocation = value;
    }

    public String getWebInfLocation() {
        return this.webInfLocation;
    }

    public String getWebRootPath() {
        String result = null;
        int i = 0;
        while (i < this.modules.length && result == null) {
            if ("<default>".equals(this.getModuleName(this.modules[i]))) {
                result = this.modules[i].getAttributeValue("root");
            }
            ++i;
        }
        return result;
    }

    public String[] getJavaSources() {
        ArrayList<String> list = new ArrayList<String>();
        String path = null;
        int i = 0;
        while (i < this.modules.length) {
            path = this.getJavaSource(this.modules[i]);
            if (path != null) {
                list.add(path.replace('\\', '/'));
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String getModuleName(XModelObject module) {
        String n = module.getAttributeValue("name");
        return n.length() == 0 ? "<default>" : n;
    }

    private String getJavaSource(XModelObject module) {
        return module.getAttributeValue("java src");
    }

    public String[] getExistingSources() {
        return this.existingSources;
    }

    public void setAddLibraries(boolean b) {
        this.addLibraries = b;
    }

    public boolean getAddLibraries() {
        return this.addLibraries;
    }

    public void setServletVersion(String version) {
        this.servletVersion = version;
        this.registry.setServletVersion(version);
    }

    public String getServletVersion() {
        return this.servletVersion;
    }

    public void setTemplateVersion(String version) {
        this.templateVersion = version;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public boolean isLinkingToProjectOutsideWorkspace() {
        return this.isLinkingToProjectOutsideWorkspace;
    }

    public void setLinkingToProjectOutsideWorkspace(boolean b) {
        this.isLinkingToProjectOutsideWorkspace = b;
    }

    protected boolean isWebXMLUpToDate(String location) {
        if (location == null) {
            return this.webXmlLocation == null;
        }
        if (!location.equals(this.webXmlLocation)) {
            return false;
        }
        try {
            long last;
            File f = new File(location);
            long l = last = f.isFile() ? f.lastModified() : -1L;
            return this.webXMLTimeStamp == last;
        }
        catch (SecurityException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            return this.webXMLTimeStamp == -1L;
        }
    }

    protected void loadWebXML(String body, String location) throws XModelException {
        String entity = this.getTarget().getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext("xml", body));
        if (entity == null || !entity.startsWith("FileWebApp")) {
            throw new XModelException(NLS.bind((String)WebUIMessages.FILE_ISNOT_RECOGNIZED, (Object)location));
        }
        this.webxml = this.getTarget().getModel().createModelObject(entity, null);
        this.webxml.setAttributeValue("name", "web");
        XModelObjectLoaderUtil.setTempBody((XModelObject)this.webxml, (String)body);
        XModelObjectLoaderUtil.getObjectLoader((XModelObject)this.webxml).load(this.webxml);
        this.webxml.getChildren();
        if ("yes".equals(this.webxml.getAttributeValue("isIncorrect"))) {
            String[] errors = ((AbstractXMLFileImpl)this.webxml).getErrors();
            String error = errors == null || errors.length == 0 ? "" : ": " + errors[0];
            String webXMLErrorMessage = NLS.bind((String)WebUIMessages.WEBDESCRIPTOR_FILE_IS_CORRUPTED, (Object)error);
            throw new XModelException(webXMLErrorMessage);
        }
    }

    public abstract String getNatureID();

    public boolean isServletVersionConsistentToWebXML() {
        if (this.webxml == null) {
            return true;
        }
        String entity = this.webxml.getModelEntity().getName();
        if ("2.3".equals(this.servletVersion) && !entity.equals("FileWebApp")) {
            return false;
        }
        if ("2.4".equals(this.servletVersion) && !entity.equals("FileWebApp24")) {
            return false;
        }
        return !"2.5".equals(this.servletVersion) || entity.equals("FileWebApp25");
    }

    public void convertWebXML(boolean backup) throws XModelException {
        if (this.webxml == null) {
            return;
        }
        String entity = this.webxml.getModelEntity().getName();
        if ("2.3".equals(this.servletVersion) && !entity.equals("FileWebApp")) {
            this.convertWebXML("FileWebApp", backup);
        } else if ("2.4".equals(this.servletVersion) && !entity.equals("FileWebApp24")) {
            this.convertWebXML("FileWebApp24", backup);
        } else if ("2.5".equals(this.servletVersion) && !entity.equals("FileWebApp25")) {
            this.convertWebXML("FileWebApp25", backup);
        }
    }

    public String getWebXMLVersion() {
        return WebAppHelper.getServletVersion(this.webxml);
    }

    private void convertWebXML(String entity, boolean backup) throws XModelException {
        if (backup) {
            this.backUp();
        }
        XModelObject newweb = XModelObjectLoaderUtil.createValidObject((XModel)this.webxml.getModel(), (String)entity);
        XAttribute[] as = newweb.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            XAttribute a;
            String n = as[i].getName();
            String xmlname = as[i].getXMLName();
            if (xmlname != null && xmlname.length() != 0 && (a = this.webxml.getModelEntity().getAttribute(n)) != null && (v = this.webxml.getAttributeValue(n)) != null && !v.equals(a.getDefaultValue())) {
                newweb.setAttributeValue(n, v);
            }
            ++i;
        }
        XModelObject[] cs = this.webxml.getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            String ent = cs[i2].getModelEntity().getName();
            if (newweb.getModelEntity().getChild(ent) != null) {
                XModelObject o = newweb.getChildByPath(cs[i2].getPathPart());
                if (o != null) {
                    EnginesLoader.merge((XModelObject)o, (XModelObject)cs[i2]);
                } else {
                    newweb.addChild(cs[i2].copy());
                }
            } else if ("WebAppJspConfig".equals(ent) || "WebAppFolderTaglibs".equals(ent)) {
                XModelObject[] ts = cs[i2].getChildren("WebAppTaglib");
                XModelObject jspConfig = WebAppHelper.getJSPConfig(newweb);
                int j = 0;
                while (j < ts.length) {
                    jspConfig.addChild(ts[j]);
                    ++j;
                }
            } else if ("WebAppTaglib".equals(ent)) {
                XModelObject jspConfig = WebAppHelper.getJSPConfig(this.webxml);
                if (jspConfig == null) {
                    jspConfig = this.webxml.getModel().createModelObject("WebAppJspConfig", null);
                    newweb.addChild(jspConfig);
                }
                jspConfig.addChild(cs[i2]);
            }
            ++i2;
        }
        if (this.webXmlLocation == null) {
            return;
        }
        String text = ((FileAnyImpl)newweb).getAsText();
        FileUtil.writeFile((File)new File(this.webXmlLocation), (String)text);
    }

    private void backUp() {
        if (this.webXmlLocation == null) {
            return;
        }
        File source = new File(this.webXmlLocation);
        File target = new File(source.getParentFile(), "web.xml." + this.getWebXMLVersion() + ".old");
        FileUtil.copyFile((File)source, (File)target);
    }
}

