/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model;

import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.AbstractExtendedXMLFileImpl;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.loaders.impl.SerializingLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.WebProcess;
import org.jboss.tools.jst.web.model.WebProcessLoader;

public abstract class AbstractWebFileImpl
extends AbstractExtendedXMLFileImpl {
    SerializingLoader loader = null;

    protected WebProcess provideWebProcess() {
        String entity = this.getProcessEntity();
        if (entity == null) {
            return null;
        }
        if (this.getModelEntity().getChild(entity) == null) {
            return null;
        }
        WebProcess process = (WebProcess)this.getChildByPath("process");
        if (process == null) {
            process = (WebProcess)this.getModel().createModelObject(entity, null);
            this.addChild(process);
        }
        return process;
    }

    protected void mergeAll(XModelObject f, boolean update) throws XModelException {
        WebProcess process = this.provideWebProcess();
        this.merge(f, !update);
        if (process != null) {
            if (!process.isPrepared() || this.isForceLoadOn()) {
                XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader((XModelObject)this);
                ((WebProcessLoader)loader).reloadProcess((XModelObject)this);
            }
            if (process.isPrepared()) {
                process.autolayout();
            }
        }
    }

    public String getAsText() {
        String body;
        boolean isIncorrect = "yes".equals(this.getAttributeValue("isIncorrect"));
        if (isIncorrect) {
            return this.getAttributeValue("incorrectBody");
        }
        String abts = this.get("actualBodyTimeStamp");
        if (abts != null && (abts.equals("0") || abts.equals("" + this.getTimeStamp()))) {
            return this.get("correctBody");
        }
        if (this.loader == null) {
            this.loader = (SerializingLoader)XModelObjectLoaderUtil.getObjectLoader((XModelObject)this);
        }
        if ((body = this.loader.serializeObject((XModelObject)this)) == null) {
            return "";
        }
        this.set("correctBody", body);
        this.set("actualBodyTimeStamp", "" + this.getTimeStamp());
        return body;
    }
}

