/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.model.handlers.FindItemOnDiagramHandler;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindReferringItemHandler
extends AbstractHandler {
    WebProcessStructureHelper helper = new WebProcessStructureHelper();

    public boolean isEnabled(XModelObject object) {
        return object != null && object.isActive();
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        XModelObject[] os = this.getReferringObjects(object);
        if (os.length == 0) {
            ServiceDialog d = object.getModel().getService();
            d.showDialog(WebUIMessages.WARNING, WebUIMessages.ITEM_ISNOT_REFERENCED, new String[]{WebUIMessages.OK, WebUIMessages.CANCEL}, null, 2);
            return;
        }
        if (os.length == 1) {
            this.selectObject(os[0]);
        } else {
            p = new Properties();
            p.put("object", object);
            String help = this.action.getProperty("help");
            p.put("help", help);
            p.put("items", os);
            String wizard = this.action.getProperty("wizard");
            SpecialWizard sw = SpecialWizardFactory.createSpecialWizard((String)wizard);
            sw.setObject((Object)p);
            int i = sw.execute();
            XModelObject selected = i != 0 ? null : (XModelObject)p.get("selected");
            this.selectObject(selected);
        }
    }

    public void selectObject(XModelObject selected) {
        if (selected == null) {
            return;
        }
        XModelObject process = this.helper.getProcess(selected);
        XModelObject parent = selected.getParent();
        if (parent != process) {
            this.selectObject(parent);
        }
        FindItemOnDiagramHandler.selectInEditor(selected);
    }

    private XModelObject[] getReferringObjects(XModelObject object) {
        XModelObject process = this.helper.getParentProcess(object);
        if (process == null) {
            return new XModelObject[0];
        }
        List<XModelObject> list = this.getTargetReferers(process, object.getPathPart());
        return list.toArray(new XModelObject[0]);
    }

    public List<XModelObject> getTargetReferers(XModelObject root, String target) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        this.fillTargetReferers(list, root, target);
        return list;
    }

    private void fillTargetReferers(List<XModelObject> list, XModelObject obj, String target) {
        XModelObject[] children = obj.getChildren();
        int i = 0;
        while (i < children.length) {
            if (target.equals(children[i].getAttributeValue("target"))) {
                list.add(children[i]);
            }
            this.fillTargetReferers(list, children[i], target);
            ++i;
        }
    }
}

