/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.server.RegistrationHelper;

public class UnregisterInServerXmlHandler
extends AbstractHandler {
    String textTemplate = null;

    public boolean isEnabled(XModelObject object) {
        String t;
        int i;
        if (this.textTemplate == null) {
            this.textTemplate = this.action.getDisplayName();
        }
        if (this.textTemplate != null && (i = (t = this.textTemplate).indexOf("server.xml")) >= 0) {
            t = String.valueOf(t.substring(0, i)) + "Server" + t.substring(i + "server.xml".length());
            ((XActionImpl)this.action).setDisplayName(t);
        }
        return object != null && this.isRegistered(object);
    }

    public boolean isEnabled(XModelObject object, XModelObject[] objects) {
        if (object != null && (objects == null || objects.length == 1)) {
            return this.isEnabled(object);
        }
        return false;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String name = object.getAttributeValue("application name");
        if (p != null && "true".equals(p.getProperty("unregisterFromAllServers"))) {
            this.unregisterFromAllServers(object);
            return;
        }
        boolean result = RegistrationHelper.unregister(EclipseResourceUtil.getProject((XModelObject)object));
        if (result) {
            ServiceDialog d = object.getModel().getService();
            String server = RegistrationHelper.getSelectedServer().getName();
            String mes = NLS.bind((String)WebUIMessages.APPLICATION_HAS_BEEN_UNREGISTERED_FROM, (Object)name, (Object)server);
            d.showDialog(WebUIMessages.MESSAGE, mes, new String[]{WebUIMessages.CLOSE}, null, 3);
        }
    }

    boolean isRegistered(XModelObject object) {
        return RegistrationHelper.isRegistered(EclipseResourceUtil.getProject((XModelObject)object));
    }

    void unregisterFromAllServers(XModelObject object) throws XModelException {
        IProject project = EclipseResourceUtil.getProject((XModelObject)object);
        IServer[] ss = ServerCore.getServers();
        int i = 0;
        while (i < ss.length) {
            if (RegistrationHelper.isRegistered(project, ss[i])) {
                RegistrationHelper.unregister(project, ss[i]);
            }
            ++i;
        }
    }
}

