/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project;

import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.jst.web.project.WebModuleConstants;

public class WebModuleImpl
extends RegularObjectImpl
implements WebModuleConstants {
    private static final long serialVersionUID = 1L;
    String lastURI = null;
    long lastURITimeStamp = -1L;

    public static String toWebModulePathPart(String name) {
        return name == null ? null : name.replace('/', '#');
    }

    public void setURI(String uri) {
        if (uri.equals(this.getURI()) && this.isNormalized()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(uri, ",");
        XModelObject[] cs = this.getChildren();
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < cs.length) {
            map.put(cs[i].getPathPart(), cs[i]);
            ++i;
        }
        HashSet<String> set = new HashSet<String>();
        String t = st.nextToken().trim();
        set.add(t);
        String to = this.getAttributeValue("URI");
        String po = this.getAttributeValue("model path");
        if (!t.equals(to)) {
            this.setAttributeValue("URI", t);
            XModelObject c = (XModelObject)map.get(t.replace('/', '#'));
            if (c != null) {
                this.setAttributeValue("model path", c.getAttributeValue("model path"));
            } else {
                this.setAttributeValue("model path", this.guessModelPath(t));
            }
        } else {
            to = null;
        }
        while (st.hasMoreTokens()) {
            t = st.nextToken().trim();
            if (set.contains(t)) continue;
            set.add(t);
            String p = t.replace('/', '#');
            XModelObject c = (XModelObject)map.remove(p);
            if (c != null) continue;
            c = this.getModel().createModelObject("JstWebConfig", null);
            c.setAttributeValue("name", this.getAttributeValue("name"));
            c.setAttributeValue("URI", t);
            if (to != null && to.equals(t)) {
                c.setAttributeValue("model path", po);
            } else {
                c.setAttributeValue("model path", this.guessModelPath(t));
            }
            this.addChild(c);
        }
        for (XModelObject o : map.values()) {
            o.removeFromParent();
            o.setModified(true);
        }
        this.lastURI = uri;
        this.lastURITimeStamp = this.getTimeStamp();
    }

    public String getURI() {
        if (this.lastURI != null && this.lastURITimeStamp == this.getTimeStamp()) {
            return this.lastURI;
        }
        String uri = this.getAttributeValue("URI");
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            uri = String.valueOf(uri) + "," + cs[i].getAttributeValue("URI");
            ++i;
        }
        return uri;
    }

    public boolean isNormalized() {
        return this.getAttributeValue("URI").indexOf(44) < 0;
    }

    public void normalize() {
        if (!this.isNormalized()) {
            this.setURI(this.getURI());
        }
    }

    private String guessModelPath(String uri) {
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        if (!uri.startsWith("/WEB-INF/")) {
            return "";
        }
        String path = uri.substring(8);
        XModelObject o = this.getModel().getByPath(path);
        return o != null ? path : "";
    }
}

