/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddJarToLibrarySetSupport;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;

public class LibrarySet {
    String name;
    String path;
    Set<String> jars = new TreeSet<String>();

    LibrarySet(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void refresh() {
        this.jars.clear();
        File f = new File(this.path);
        if (!f.isDirectory()) {
            return;
        }
        File[] fs = f.listFiles();
        if (fs == null) {
            return;
        }
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isFile() && fs[i].getName().endsWith(".jar")) {
                this.jars.add(fs[i].getName());
            }
            ++i;
        }
    }

    public String[] getJarList() {
        return this.jars.toArray(new String[0]);
    }

    public String addJar() {
        return AddJarToLibrarySetSupport.run(this);
    }

    public String addJar(String location) {
        int q;
        String jarname;
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        File f = new File(location);
        if (!f.exists()) {
            d.showDialog(WebUIMessages.ERROR, NLS.bind((String)WebUIMessages.FILE_DOESNOT_EXIST, (Object)location), new String[]{WebUIMessages.CLOSE}, null, 1);
        }
        if (this.jars.contains(jarname = f.getName()) && (q = d.showDialog(WebUIMessages.WARNING, NLS.bind((String)WebUIMessages.LIBRARYSET_CONTAINS, (Object)jarname), new String[]{WebUIMessages.OK, WebUIMessages.CANCEL}, null, 2)) != 0) {
            return null;
        }
        File jf = this.getFile(jarname);
        FileUtil.copyFile((File)f, (File)jf, (boolean)true, (boolean)true);
        if (jf.isFile()) {
            this.jars.add(jarname);
        }
        return jarname;
    }

    public boolean removeJar(String jarname) {
        File jf = this.getFile(jarname);
        if (jf.isFile()) {
            if (!AbstractWebProjectTemplate.confirm(NLS.bind((String)WebUIMessages.YOU_WANT_TO_DELETE_FROM_LIBRARYSET, (Object)jarname, (Object)this.name))) {
                return false;
            }
            jf.delete();
        }
        if (!jf.exists()) {
            this.jars.remove(jarname);
            return true;
        }
        return false;
    }

    File getFile(String jarname) {
        return new File(String.valueOf(this.path) + "/" + jarname);
    }
}

