/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.project.Watcher;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.helpers.WebAppConfig;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWebProjectHelper {
    public void createProject(XModelObject object, Properties p) throws XModelException {
        XModel model = object.getModel();
        ((XModelImpl)model).waitForLoading();
        XModelObject webxml = WebAppHelper.getWebApp(model);
        if (webxml == null) {
            throw new XModelException("Cannot find web.xml");
        }
        String location = ((IFile)webxml.getAdapter(IFile.class)).getLocation().toString();
        XModelObject webinf = model.getByPath("FileSystems/WEB-INF");
        XModelObject fss = model.getByPath("FileSystems");
        fss.setAttributeValue("application name", p.getProperty("name"));
        File webInfDir = ((IResource)webinf.getAdapter(IResource.class)).getLocation().toFile();
        Map<String, String> modules = NewWebProjectHelper.getModules(location);
        for (Map.Entry<String, String> entry : modules.entrySet()) {
            File layoutFile;
            String module = entry.getKey();
            String config = entry.getValue();
            String fileName = config.substring(config.indexOf(47, 1) + 1);
            File configFile = new File(location, fileName);
            if (!configFile.isFile() || !fileName.toLowerCase().endsWith(".xml") || (layoutFile = new File(location, "." + fileName.substring(0, fileName.length()) + ".strutsdia")).exists()) continue;
            FileUtil.writeFile((File)layoutFile, (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<PROCESS ENTITY=\"StrutsProcess\" MODULE=\"" + module + "\"/>"));
        }
        String libName = NewWebProjectHelper.getLibLocation(model);
        if (libName != null && libName.length() > 0) {
            File libDir = new File(libName);
            libName = new File(libName).getParentFile().equals(webInfDir) ? String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib/" : String.valueOf(libName.replace('\\', '/')) + "/";
            File[] jars = libDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (!file.isFile()) {
                        return false;
                    }
                    String name = file.getName().toLowerCase();
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            if (jars != null) {
                int i = 0;
                while (i < jars.length) {
                    String jarName = jars[i].getName();
                    Properties fsProp = new Properties();
                    fsProp.setProperty("name", "lib-" + jarName);
                    fsProp.setProperty("location", String.valueOf(libName) + jarName);
                    fsProp.setProperty("info", "hidden=yes");
                    XModelObject fsJar = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"FileSystemJar", (Properties)fsProp);
                    if (fss.getChildByPath(fsJar.getPathPart()) == null) {
                        DefaultCreateHandler.addCreatedObject((XModelObject)fss, (XModelObject)fsJar, (boolean)false, (int)-1);
                    }
                    ++i;
                }
            }
        }
        model.save();
        model.update();
        NewWebProjectHelper.updateOverlapped(model);
        this.registerTLDs(model, p);
        Watcher.getInstance((XModel)model).forceUpdate();
        model.save();
    }

    public static String getLibLocation(XModel model) {
        XModelObject lib = model.getByPath("FileSystems/lib");
        if (lib != null) {
            return ((IResource)lib.getAdapter(IResource.class)).getLocation().toString();
        }
        XModelObject fs = model.getByPath("FileSystems/WEB-INF");
        return String.valueOf(((IResource)fs.getAdapter(IResource.class)).getLocation().toString()) + "/lib";
    }

    public static Map<String, String> getTemplates(String version, String templ) {
        HashMap<String, String> map = new HashMap<String, String>();
        File dir = new File(templ, "struts/" + version);
        File[] files = dir.listFiles();
        if (files == null) {
            return map;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            try {
                String ext;
                if (file.isDirectory()) {
                    map.put(name, file.toURL().toString());
                } else if (file.isFile() && ("jar".equals(ext = name.substring(name.indexOf(46) + 1).toLowerCase()) || "zip".equals(ext))) {
                    map.put(name.substring(0, ext.length() - 1), file.toURL().toString());
                }
            }
            catch (MalformedURLException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i;
        }
        return map;
    }

    public static void updateOverlapped(XModel model) {
        FileSystemsImpl fs = (FileSystemsImpl)model.getByPath("FileSystems");
        if (fs != null) {
            fs.updateOverlapped();
        }
    }

    public static Map<String, String> getModules(String location) {
        HashMap<String, String> modules = new HashMap<String, String>();
        File webXML = new File(location, "web.xml");
        if (!webXML.isFile()) {
            return modules;
        }
        try {
            WebAppConfig config = new WebAppConfig(webXML);
            Element[] servlets = config.getServletsByClass("org.apache.struts.action.ActionServlet");
            int i = 0;
            while (i < servlets.length) {
                Map<String, String> params = config.getInitParamsAsMap(servlets[i]);
                for (String name : params.keySet()) {
                    if (!name.startsWith("config/") && !name.equals("config")) continue;
                    String value = params.get(name);
                    modules.put(name.substring(6), value);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return modules;
    }

    private void registerTLDs(XModel model, Properties p) {
        String tlds = p.getProperty("TLDs");
        XModelObject webxml = WebAppHelper.getWebApp(model);
        if (webxml == null || tlds == null) {
            return;
        }
        String[] ts = XModelObjectUtil.asStringArray((String)tlds);
        int i = 0;
        while (i < ts.length) {
            XModelObject taglib = XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"WebAppTaglib");
            String path = "/WEB-INF/" + ts[i];
            String uri = path;
            if (uri.endsWith(".tld")) {
                uri = uri.substring(0, uri.length() - 4);
            }
            taglib.setAttributeValue("taglib-uri", uri);
            taglib.setAttributeValue("taglib-location", path);
            if (webxml.getChildByPath(taglib.getPathPart()) == null) {
                WebAppHelper.getJSPConfig(webxml).addChild(taglib);
                webxml.setModified(true);
            }
            ++i;
        }
    }
}

