/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.refactoring;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class JSFPagesRefactoringChange
extends CompositeChange {
    protected String newName;
    protected String oldName;
    protected XModel model;
    protected XModelObject fileObject;
    String resourcePath;
    String newResourcePath;
    String jsfResourcePath;
    String newJsfResourcePath;

    public JSFPagesRefactoringChange(XModelObject fileObject, String newName) {
        super(WebUIMessages.JSP_REFACTORING);
        int i;
        this.model = fileObject.getModel();
        this.fileObject = fileObject;
        this.resourcePath = XModelObjectLoaderUtil.getResourcePath((XModelObject)fileObject);
        int n = i = this.resourcePath == null ? -1 : this.resourcePath.lastIndexOf(47);
        if (i >= 0) {
            this.newResourcePath = String.valueOf(this.resourcePath.substring(0, i + 1)) + newName;
        }
        this.newName = newName;
        this.oldName = fileObject.getAttributeValue("name");
        List<Object> list = WebPromptingProvider.getInstance().getList(this.model, "jsf.get.url", this.resourcePath, new Properties());
        if (list != null && list.size() > 0) {
            this.jsfResourcePath = list.get(0).toString();
        }
        if ((list = WebPromptingProvider.getInstance().getList(this.model, "jsf.get.url", this.newResourcePath, new Properties())) != null && list.size() > 0) {
            this.newJsfResourcePath = list.get(0).toString();
        }
        try {
            this.addChanges();
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public XModel getModel() {
        return this.model;
    }

    private void addChanges() throws Exception {
        if (this.model == null) {
            return;
        }
        XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.model);
        if (webRoot == null) {
            return;
        }
        this.addChanges(webRoot.getChildren());
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i].getFileType() == 2) {
                this.addChanges(objects[i].getChildren());
            } else {
                FileAnyImpl f;
                String text;
                String entity = objects[i].getModelEntity().getName();
                if (".FileJSP.FileHTML.FileXHTML.".indexOf("." + entity + ".") >= 0 && (text = (f = (FileAnyImpl)objects[i]).getAsText()) != null && text.indexOf(this.oldName) >= 0) {
                    Properties replacements = this.createReplacements(f);
                    RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)replacements, (CompositeChange)this);
                }
            }
            ++i;
        }
    }

    Properties createReplacements(FileAnyImpl f) {
        IFile f1;
        Properties replacements = new Properties();
        if (this.resourcePath == null) {
            return replacements;
        }
        char lastChar = this.fileObject.getFileType() == 1 ? (char)'\"' : '/';
        replacements.setProperty("\"" + this.resourcePath + lastChar, "\"" + this.newResourcePath + lastChar);
        replacements.setProperty("\"." + this.resourcePath + lastChar, "\"." + this.newResourcePath + lastChar);
        if (this.jsfResourcePath != null) {
            replacements.setProperty("\"" + this.jsfResourcePath + lastChar, "\"" + this.newJsfResourcePath + lastChar);
        }
        if ((f1 = (IFile)EclipseResourceUtil.getResource((XModelObject)f)) == null) {
            return replacements;
        }
        String path1 = f1.getParent().getLocation().toString().replace('\\', '/');
        IResource f2 = EclipseResourceUtil.getResource((XModelObject)this.fileObject);
        if (f2 == null) {
            return replacements;
        }
        String path2 = f2.getLocation().toString().replace('\\', '/');
        String relativePath = FileUtil.getRelativePath((String)path1, (String)path2);
        if (relativePath == null) {
            return replacements;
        }
        int i = relativePath.lastIndexOf(47);
        String newRelativePath = String.valueOf(relativePath.substring(0, i + 1)) + this.newName;
        if (relativePath.startsWith("/")) {
            replacements.setProperty("\"" + relativePath.substring(1) + lastChar, "\"" + newRelativePath.substring(1) + lastChar);
            replacements.setProperty("\"." + relativePath + lastChar, "\"." + newRelativePath + lastChar);
        }
        return replacements;
    }
}

