/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.tools.jst.web.server.ServerManagerListener;

public class ServerManager {
    private static ServerManager instance;
    private List<ServerManagerListener> listeners = new ArrayList<ServerManagerListener>();
    private IServerListener serverListener;
    protected IServer[] servers = new IServer[0];
    IServer selected = null;
    static String DEFAULT_WEB_SERVER;

    static {
        DEFAULT_WEB_SERVER = "org.jboss.tools.jst.web.defaultWebServer";
    }

    public static synchronized ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public ServerManager() {
        this.serverListener = new ServerListenerImpl();
        this.load();
    }

    void load() {
        this.servers = (IServer[])ServerCore.getServers().clone();
        this.loadSelectedServer();
        ServerResourceListenerImpl listener = new ServerResourceListenerImpl();
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)listener);
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)listener);
    }

    private void loadSelectedServer() {
        if (this.servers == null || this.servers.length == 0) {
            return;
        }
        String ds = ServerManager.getDefaultWebServer();
        IServer s = this.getServer(ds);
        if (s == null && this.servers.length > 0) {
            s = this.servers[0];
            ServerManager.setDefaultWebServer(this.servers[0].getId());
        }
        this.setSelectedServerInternal(s);
    }

    public IServer[] getServers() {
        return this.servers;
    }

    public IServer getServer(String serverId) {
        int i = 0;
        while (i < this.servers.length) {
            if (this.servers[i].getId().equals(serverId)) {
                return this.servers[i];
            }
            ++i;
        }
        return null;
    }

    public void addListener(ServerManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ServerManagerListener listener) {
        this.listeners.remove(listener);
    }

    void fire() {
        ServerManagerListener[] ls = this.listeners.toArray(new ServerManagerListener[0]);
        int i = 0;
        while (i < ls.length) {
            ls[i].serverManagerChanged();
            ++i;
        }
    }

    public void setSelectedServer(String id) {
        IServer server = this.getServer(id);
        if (server == this.selected) {
            return;
        }
        this.setSelectedServerInternal(server);
        ServerManager.setDefaultWebServer(id);
        this.fire();
    }

    private void setSelectedServerInternal(IServer server) {
        if (this.selected == server) {
            return;
        }
        if (this.selected != null) {
            this.selected.removeServerListener(this.serverListener);
        }
        this.selected = server;
        if (this.selected != null) {
            this.selected.addServerListener(this.serverListener);
        }
    }

    public String getSelectedServerId() {
        String result = ServerManager.getDefaultWebServer();
        return result == null ? "" : result;
    }

    public IServer getSelectedServer() {
        return this.selected;
    }

    static String getDefaultWebServer() {
        String result = ServerManager.getInstancePreference(DEFAULT_WEB_SERVER);
        return result;
    }

    static void setDefaultWebServer(String value) {
        ServerManager.getInstancePreferences().put(DEFAULT_WEB_SERVER, value);
    }

    static IEclipsePreferences getInstancePreferences() {
        return new InstanceScope().getNode("org.jboss.tools.jst.web");
    }

    static IEclipsePreferences getDefaultPreferences() {
        return new DefaultScope().getNode("org.jboss.tools.jst.web");
    }

    static String getInstancePreference(String key) {
        IEclipsePreferences p = ServerManager.getInstancePreferences();
        String value = p == null ? null : p.get(key, null);
        return value != null ? value : ServerManager.getDefaultPreference(key);
    }

    static String getDefaultPreference(String key) {
        IEclipsePreferences p = ServerManager.getDefaultPreferences();
        return p == null ? null : p.get(key, null);
    }

    class ServerListenerImpl
    implements IServerListener {
        ServerListenerImpl() {
        }

        public void serverChanged(ServerEvent arg0) {
            ServerManager.this.fire();
        }
    }

    class ServerResourceListenerImpl
    implements IRuntimeLifecycleListener,
    IServerLifecycleListener {
        ServerResourceListenerImpl() {
        }

        public void serverAdded(IServer server) {
            IServer[] ss = new IServer[ServerManager.this.servers.length + 1];
            System.arraycopy(ServerManager.this.servers, 0, ss, 0, ServerManager.this.servers.length);
            ss[ServerManager.this.servers.length] = server;
            ServerManager.this.servers = ss;
            ServerManager.this.loadSelectedServer();
            ServerManager.this.fire();
        }

        public void serverChanged(IServer server) {
            ServerManager.this.fire();
        }

        public void serverRemoved(IServer server) {
            ArrayList<IServer> l = new ArrayList<IServer>();
            int i = 0;
            while (i < ServerManager.this.servers.length) {
                if (ServerManager.this.servers[i] != server) {
                    l.add(ServerManager.this.servers[i]);
                }
                ++i;
            }
            if (l.size() == ServerManager.this.servers.length) {
                return;
            }
            ServerManager.this.servers = l.toArray(new IServer[0]);
            ServerManager.this.loadSelectedServer();
            ServerManager.this.fire();
        }

        public void runtimeAdded(IRuntime runtime) {
            ServerManager.this.fire();
        }

        public void runtimeChanged(IRuntime runtime) {
            ServerManager.this.fire();
        }

        public void runtimeRemoved(IRuntime runtime) {
            ServerManager.this.fire();
        }
    }
}

