/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tld.model.handlers;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.model.tree.AllTldsTree;
import org.jboss.tools.jst.web.tld.model.TLDUtil;
import org.jboss.tools.jst.web.tld.model.handlers.PaletteAdopt;
import org.jboss.tools.jst.web.tld.model.helpers.TLDToPaletteHelper;

public class ImportTLDToPaletteSupport
extends SpecialWizardSupport {
    static String NAME = "name";
    static String TLD = "tld";
    static String PARENT_GROUP = "parent group";
    Map<String, XModelObject> groups;
    XModelObject palette;
    AllTldsTree tree = new AllTldsTree();
    XModelObject selectedFile;
    String path;
    protected DefaultWizardDataValidator validator = new ImportTLDValidator();

    public void reset() {
        this.initParentName();
        this.tree.setConstraint(new Object[]{this.getEntityData()[0].getAttributeData()[0].getAttribute()});
        this.tree.getChildren(this.tree.getRoot());
        this.selectedFile = (XModelObject)this.getProperties().get("initialSelection");
        if (this.selectedFile != null) {
            this.path = this.tree.getValue(this.selectedFile);
            this.setAttributeValue(0, TLD, this.tree.getValue(this.selectedFile));
            this.onPathModified();
        } else {
            this.path = null;
        }
    }

    void initParentName() {
        String g;
        this.groups = new TreeMap<String, XModelObject>();
        this.palette = PreferenceModelUtilities.getPreferenceModel().getByPath("%Palette%");
        this.groups.put("", this.palette);
        this.collectParents(this.palette);
        XModelObject t = (XModelObject)this.getProperties().get("target");
        if (t != null && t != this.target && (g = t.getAttributeValue(NAME)) != null && this.groups.containsKey(g)) {
            this.getProperties().setProperty(PARENT_GROUP, g);
        }
    }

    void collectParents(XModelObject palette) {
        XModelObject[] cs = palette.getChildren();
        int i = 0;
        while (i < cs.length) {
            String kind = cs[i].getAttributeValue("element type");
            if ("group".equals(kind) || "sub-group".equals(kind)) {
                String name = cs[i].getAttributeValue(NAME);
                this.groups.put(name, cs[i]);
            }
            ++i;
        }
        this.getProperties().put("groups", this.groups.keySet().toArray(new String[0]));
    }

    public void action(String name) throws XModelException {
        if (OK.equals(name) || FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        String name = p0.getProperty(NAME);
        String path = p0.getProperty(TLD);
        XModelObject tld = this.getSelectedResource(path);
        String parentName = this.getProperties().getProperty(PARENT_GROUP);
        XModelObject parent = this.groups.get(parentName);
        if (parent == null) {
            Properties p = new Properties();
            p.setProperty(NAME, parentName);
            parent = this.getTarget().getModel().createModelObject("SharablePageTabHTML", p);
            DefaultCreateHandler.addCreatedObject((XModelObject)this.palette, (XModelObject)parent, (Properties)this.getProperties());
        }
        TLDToPaletteHelper h = new TLDToPaletteHelper();
        XModelObject added = h.createGroupByTLD(tld, this.getTarget().getModel());
        added.setAttributeValue(NAME, name);
        added.setAttributeValue("library uri", this.getAttributeValue(0, "library uri"));
        added.setAttributeValue("default prefix", this.getAttributeValue(0, "default prefix"));
        PaletteAdopt.add(parent, this.getTarget(), added);
        parent.getModel().saveOptions();
    }

    XModelObject getSelectedResource(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(this.path)) {
            return this.selectedFile;
        }
        this.path = path;
        try {
            this.selectedFile = this.tree.find(path);
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return this.selectedFile;
    }

    public void onPathModified() {
        if (this.selectedFile == null) {
            return;
        }
        String name = this.selectedFile.getAttributeValue("display-name");
        if (name == null || name.length() == 0) {
            name = this.selectedFile.getAttributeValue("shortname");
        }
        this.setAttributeValue(0, NAME, name);
        String pref = TLDUtil.isTaglib(this.selectedFile) ? TLDToPaletteHelper.getTldName(this.selectedFile) : (TLDUtil.isFaceletTaglib(this.selectedFile) ? TLDToPaletteHelper.getFaceletTldName(this.selectedFile) : "");
        this.setAttributeValue(0, "default prefix", pref);
        String uri = this.selectedFile.getAttributeValue("uri");
        this.setAttributeValue(0, "library uri", uri);
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    public String getStepImplementingClass(int stepId) {
        return "org.jboss.tools.jst.web.ui.wizards.palette.ImportTLDPage";
    }

    class ImportTLDValidator
    extends DefaultWizardDataValidator {
        ImportTLDValidator() {
        }

        public void validate(Properties data) {
            this.message = null;
            String tld = data.getProperty(TLD);
            IStatus status = ResourcesPlugin.getWorkspace().validatePath(tld, 1);
            if (status != null && !status.isOK()) {
                this.message = status.getMessage();
                return;
            }
            XModelObject s = ImportTLDToPaletteSupport.this.getSelectedResource(tld);
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String name = data.getProperty(NAME);
            String parentName = ImportTLDToPaletteSupport.this.getProperties().getProperty(PARENT_GROUP);
            if (parentName == null || parentName.length() == 0) {
                this.message = WebUIMessages.PARENT_GROUP_MUST_BE_SPECIFIED;
                return;
            }
            XModelObject group = ImportTLDToPaletteSupport.this.groups.get(parentName);
            if (group != null && group.getChildByPath(name) != null) {
                String string = this.message = parentName.length() == 0 ? NLS.bind((String)WebUIMessages.PALETTE_ALREADY_CONTAINS_TAB, (Object)name) : NLS.bind((String)WebUIMessages.PALETTE_ALREADY_CONTAINS_TAB_2P, (Object)parentName, (Object)name);
            }
            if (this.message != null) {
                return;
            }
            if (s == null) {
                this.message = WebUIMessages.PATH_TO_TLD_ISNOT_CORRECT;
                return;
            }
        }
    }
}

