/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileAuxiliary;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.loaders.impl.SimpleWebFileLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EntityXMLRegistration;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.AbstractWebDiagramLoader;
import org.jboss.tools.jst.web.model.WebProcessLoader;
import org.jboss.tools.jst.web.tiles.model.FTLoaderUtil;
import org.jboss.tools.jst.web.tiles.model.TilesConstants;
import org.jboss.tools.jst.web.tiles.model.TilesProcessImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTilesLoader
extends AbstractWebDiagramLoader
implements WebProcessLoader,
TilesConstants {
    static boolean DO_NOT_SAVE = true;

    protected FileAuxiliary createFileAuxiliary() {
        return new FileAuxiliary("l4t", false);
    }

    protected XModelObjectLoaderUtil createUtil() {
        return new FTLoaderUtil();
    }

    public void load(XModelObject object) {
        boolean hasErrors;
        String body = XModelObjectLoaderUtil.getTempBody((XModelObject)object);
        int resolution = EntityXMLRegistration.getInstance().resolve(object.getModelEntity());
        String[] errors = XMLUtil.getXMLErrors((Reader)new StringReader(body), (resolution == EntityXMLRegistration.DTD ? 1 : 0) != 0, (resolution == EntityXMLRegistration.SCHEMA ? 1 : 0) != 0);
        boolean bl = hasErrors = errors != null && errors.length > 0;
        if (hasErrors) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "-1");
        } else {
            object.setAttributeValue("isIncorrect", "no");
            object.set("correctBody", body);
            object.set("actualBodyTimeStamp", "0");
            object.setAttributeValue("incorrectBody", "");
        }
        Document doc = XMLUtil.getDocument((Reader)new StringReader(body));
        if (doc == null) {
            XModelObjectLoaderUtil.addRequiredChildren((XModelObject)object);
            return;
        }
        Element element = doc.getDocumentElement();
        this.util.load(element, object);
        this.setEncoding(object, body);
        NodeList nl = doc.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof DocumentType) {
                DocumentType dt = (DocumentType)n;
                object.setAttributeValue("systemId", dt.getSystemId());
            }
            ++i;
        }
        String loadingError = this.util.getError();
        this.reloadProcess(object);
        object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        ((AbstractXMLFileImpl)object).setLoaderError(loadingError);
        if (!hasErrors && loadingError != null) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        }
    }

    public void reloadProcess(XModelObject object) {
        Document doc2;
        String bodyAux;
        TilesProcessImpl process = (TilesProcessImpl)object.getChildByPath("process");
        if (process == null) {
            return;
        }
        process.setReference(object);
        if (!object.isActive()) {
            return;
        }
        String string = bodyAux = object.getParent() == null ? null : this.aux.read(object.getParent(), object);
        if (bodyAux != null && (doc2 = XMLUtil.getDocument((Reader)new StringReader(bodyAux))) != null) {
            this.util.load(doc2.getDocumentElement(), (XModelObject)process);
        }
        process.setReference(null);
        process.firePrepared();
    }

    public boolean saveLayout(XModelObject object) {
        XModelObject process;
        XModelObjectLoaderUtil util;
        block4: {
            if (DO_NOT_SAVE) {
                return true;
            }
            util = new XModelObjectLoaderUtil();
            try {
                process = object.getChildByPath("process");
                if (process != null) break block4;
                return true;
            }
            catch (IOException exc) {
                ModelPlugin.getPluginLog().logError((Throwable)exc);
                return false;
            }
        }
        process.setModified(true);
        Element element = XMLUtil.createDocumentElement((String)"PROCESS");
        util.saveAttributes(element, process);
        util.saveChildren(element, process);
        StringWriter sw = new StringWriter();
        XModelObjectLoaderUtil.serialize((Element)element, (Writer)sw);
        XModelObjectLoaderUtil.setTempBody((XModelObject)process, (String)sw.toString());
        this.aux.write(object.getParent(), object, process);
        return true;
    }

    public String serializeMainObject(XModelObject object) {
        String systemId = object.getAttributeValue("systemId");
        if (systemId == null || systemId.length() == 0) {
            systemId = "http://jakarta.apache.org/struts/dtds/tiles-config_1_1.dtd";
        }
        String publicId = "-//Apache Software Foundation//DTD Tiles Configuration 1.1//EN";
        Element element = XMLUtil.createDocumentElement((String)object.getModelEntity().getXMLSubPath(), (String)"tiles-definitions", (String)publicId, (String)systemId, null);
        String result = null;
        try {
            this.util.setup(null, false);
            String att = object.getAttributeValue("comment");
            if (att.length() > 0) {
                this.util.saveAttribute(element, "#comment", att);
            }
            this.util.saveChildren(element, object);
            result = SimpleWebFileLoader.serialize((Element)element, (XModelObject)object);
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }
}

