/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.helpers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.WebProject;

class Registrator {
    String nature;
    String className;
    SpecialWizard wizard;

    public Registrator(String nature, String className) {
        this.nature = nature;
        this.className = className;
    }

    public boolean canRegister(XModel model) {
        if (!EclipseResourceUtil.hasNature((XModel)model, (String)this.nature)) {
            return false;
        }
        if (this.wizard == null && this.className != null) {
            this.wizard = SpecialWizardFactory.createSpecialWizard((String)this.className);
            this.className = null;
        }
        return this.wizard != null;
    }

    public boolean register(XModel model, XModelObject file, String oldPath, boolean test) {
        Properties p = new Properties();
        p.put("model", model);
        String webRoot = WebProject.getInstance((XModel)model).getWebRootLocation().replace('\\', '/');
        if (!webRoot.endsWith("/")) {
            webRoot = String.valueOf(webRoot) + "/";
        }
        if (file != null && file.isActive()) {
            String path = ((FileAnyImpl)file).getAbsolutePath();
            if (!path.toLowerCase().startsWith(webRoot.toLowerCase())) {
                return false;
            }
            path = path.substring(webRoot.length() - 1);
            p.setProperty("path", path);
        }
        if (oldPath != null) {
            oldPath = oldPath.substring(webRoot.length() - 1);
            p.setProperty("oldPath", oldPath);
        }
        if (test) {
            p.setProperty("test", "true");
        }
        this.wizard.setObject((Object)p);
        return this.wizard.execute() == 0;
    }
}

