/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.model.helpers;

import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;
import org.jboss.tools.jst.web.tiles.model.TilesConstants;
import org.jboss.tools.jst.web.tiles.model.TilesProcessItemImpl;
import org.jboss.tools.jst.web.tiles.model.helpers.TilesDefinitionSet;

public class TilesStructureHelper
extends WebProcessStructureHelper
implements TilesConstants {
    public static final TilesStructureHelper instance = new TilesStructureHelper();

    public XModelObject getParentProcess(XModelObject element) {
        XModelObject p = element;
        while (p != null && p.getFileType() == 0 && !"TilesProcess".equals(p.getModelEntity().getName())) {
            p = p.getParent();
        }
        return p;
    }

    public XModelObject[] getItems(XModelObject process) {
        return process.getChildren("TilesProcessItem");
    }

    public XModelObject[] getOutputs(XModelObject item) {
        return item.getChildren("TilesProcessItemOutput");
    }

    public String getPath(XModelObject element) {
        return element.getAttributeValue("path");
    }

    public XModelObject getItemOutputTarget(XModelObject itemOutput) {
        return itemOutput.getParent().getParent().getChildByPath(itemOutput.getAttributeValue("target"));
    }

    public boolean isNotDefinedInThisFile(XModelObject item) {
        if (!(item instanceof TilesProcessItemImpl)) {
            return false;
        }
        return ((TilesProcessItemImpl)item).getReference() == null;
    }

    public XModelObject findItemInOtherFile(XModelObject item) {
        if (!this.isNotDefinedInThisFile(item)) {
            return null;
        }
        XModelObject d = TilesDefinitionSet.getInstance(item.getModel()).getDefinitions().get(item.getAttributeValue("name"));
        XModelObject p = d == null ? null : this.getProcess(d);
        return p == null ? null : p.getChildByPath(d.getPathPart());
    }

    public boolean isUnconfirmedItem(XModelObject item) {
        if (!(item instanceof TilesProcessItemImpl)) {
            return false;
        }
        if (this.getReference(item) != null) {
            return false;
        }
        return !"true".equals(item.getAttributeValue("confirmed"));
    }

    public XModelObject getReference(XModelObject diagramObject) {
        if (diagramObject instanceof ReferenceObject) {
            return ((ReferenceObject)diagramObject).getReference();
        }
        return null;
    }

    public boolean hasErrors(XModelObject diagramObject) {
        if (diagramObject instanceof ReferenceObject) {
            XModelObject reference = ((ReferenceObject)diagramObject).getReference();
            return XMarkerManager.getInstance().hasErrors(reference);
        }
        return XMarkerManager.getInstance().hasErrors(diagramObject);
    }

    public boolean canMakeLink(XModelObject sourceItem, XModelObject targetItem) {
        if (sourceItem == null || !sourceItem.isObjectEditable()) {
            return false;
        }
        if (this.isNotDefinedInThisFile(sourceItem)) {
            return false;
        }
        XModelObject object = targetItem;
        while (object != null) {
            if (sourceItem.equals(object)) {
                return false;
            }
            XModelObject[] outputs = this.getOutputs(object);
            if (outputs.length <= 0) break;
            object = this.getItemOutputTarget(outputs[0]);
        }
        return true;
    }

    public void makeLink(XModelObject sourceItem, XModelObject targetItem) throws XModelException {
        XModelObject sourceReference = this.getReference(sourceItem);
        if (sourceReference == null) {
            return;
        }
        sourceReference.getModel().editObjectAttribute(sourceReference, "extends", targetItem.getAttributeValue("name"));
    }
}

