/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.log;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.common.Messages;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.common.log.StatusFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUIPlugin
extends AbstractUIPlugin
implements IPluginLog {
    private HashMap<String, ImageDescriptor> fImageDescRegistry = null;

    @Override
    public void logError(String message, Throwable t) {
        LogHelper.logError((Plugin)this, message, t);
    }

    @Override
    public void logError(String message) {
        LogHelper.logError((Plugin)this, message);
    }

    @Override
    public void logError(Throwable t) {
        LogHelper.logError((Plugin)this, t);
    }

    @Override
    public void logInfo(String message, Throwable t) {
        LogHelper.logInfo((Plugin)this, message, t);
    }

    @Override
    public void logInfo(String message) {
        LogHelper.logInfo((Plugin)this, message);
    }

    @Override
    public void logWarning(String message, Throwable t) {
        LogHelper.logWarning((Plugin)this, message, t);
    }

    @Override
    public void logWarning(String message) {
        LogHelper.logWarning((Plugin)this, message);
    }

    @Override
    public void logWarning(Throwable t) {
        LogHelper.logWarning((Plugin)this, t);
    }

    public void showError(String message, Throwable t) {
        this.logError(message, t);
        Shell shell = Display.getDefault().getActiveShell();
        IStatus s = StatusFactory.getInstance(4, this.getBundle().getSymbolicName(), message, t);
        ErrorDialog.openError((Shell)shell, (String)Messages.BaseUIPlugin_ErrorDialogTitle, (String)message, (IStatus)s);
    }

    public Image getImage(String resource) {
        Image image = this.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = this.getImageDescriptorFromRegistry(resource);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                this.getImageRegistry().put(resource, image);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptorFromRegistry(String resource) {
        ImageDescriptor imageDescriptor = null;
        ImageDescriptor o = this.getImageDescriptorRegistry().get(resource);
        imageDescriptor = o == null ? this.createImageDescriptor(resource) : o;
        return imageDescriptor;
    }

    private HashMap<String, ImageDescriptor> getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap();
        }
        return this.fImageDescRegistry;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)imageFilePath);
        if (imageDescriptor != null) {
            this.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }
}

