/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.reporting;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.common.util.HttpUtil;

public class Submit {
    public static String REPORT_DESRIPTION_PARAMETER_NAME = CommonPlugin.getMessage("%reportParameterName");
    private static String URL = CommonPlugin.getMessage("%reportingUrl");
    private static String JOB_NAME = CommonPlugin.getMessage("%reportingJobName");
    private static String ERROR_MESSAGE = CommonPlugin.getMessage("%errorReportingMessage");
    private static Submit INSTANCE = new Submit();

    private Submit() {
    }

    public static Submit getInstance() {
        return INSTANCE;
    }

    public void submit(final String reportText, final boolean cleanBuffer) {
        Job job = new Job(JOB_NAME){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    Submit.this.submitReport(reportText);
                }
                catch (IOException e) {
                    String exceptionMessage = e.getMessage();
                    String message = ERROR_MESSAGE;
                    if (exceptionMessage != null && exceptionMessage.trim().length() > 0) {
                        message = String.valueOf(message) + ".\r\n" + e.getClass().getName() + ": " + exceptionMessage;
                    }
                    Status status = new Status(2, "org.jboss.tools.common", 2, message, (Throwable)e);
                    return status;
                }
                if (cleanBuffer) {
                    ProblemReportingHelper.buffer.clean();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private int submitReport(String reportText) throws IOException {
        HttpClient httpClient = HttpUtil.createHttpClient(URL);
        PostMethod httpPost = new PostMethod(URL);
        httpPost.addParameter(REPORT_DESRIPTION_PARAMETER_NAME, reportText);
        int responseCode = httpClient.executeMethod((HttpMethod)httpPost);
        return responseCode;
    }
}

