/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.Messages;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.xml.ErrorHandlerImpl;
import org.jboss.tools.common.xml.XMLEntityResolverImpl;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXValidator {
    protected static final String FATAL_ERROR_PROCESSING_FEATURE_ID = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ENTITY_RESOLVER_PROPERTY_ID = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String VALIDATION_SCHEMA_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String VALIDATION_SCHEMA_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String VALIDATION_DYNAMIC_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_SAX_PARSER_CLASS_NAME = "org.apache.xerces.parsers.SAXParser";

    XMLReader createParser() {
        DefaultHandler handler = new DefaultHandler();
        XMLReader parserInstance = null;
        try {
            parserInstance = XMLReaderFactory.createXMLReader(DEFAULT_SAX_PARSER_CLASS_NAME);
        }
        catch (SAXException sAXException) {
            return null;
        }
        SAXValidator.setFeature(parserInstance, NAMESPACES_FEATURE_ID, true);
        SAXValidator.setFeature(parserInstance, NAMESPACE_PREFIXES_FEATURE_ID, false);
        SAXValidator.setFeature(parserInstance, VALIDATION_FEATURE_ID, true);
        SAXValidator.setFeature(parserInstance, VALIDATION_SCHEMA_FEATURE_ID, true);
        SAXValidator.setFeature(parserInstance, VALIDATION_SCHEMA_CHECKING_FEATURE_ID, false);
        SAXValidator.setFeature(parserInstance, VALIDATION_DYNAMIC_FEATURE_ID, false);
        SAXValidator.setFeature(parserInstance, FATAL_ERROR_PROCESSING_FEATURE_ID, false);
        try {
            parserInstance.setProperty(ENTITY_RESOLVER_PROPERTY_ID, new XMLEntityResolverImpl());
        }
        catch (SAXNotRecognizedException e1) {
            CommonPlugin.getPluginLog().logError(String.valueOf(e1.getMessage()), e1);
        }
        catch (SAXNotSupportedException e1) {
            CommonPlugin.getPluginLog().logError(String.valueOf(e1.getMessage()), e1);
        }
        parserInstance.setContentHandler(handler);
        parserInstance.setErrorHandler(handler);
        return parserInstance;
    }

    public static void setFeature(XMLReader parser, String name, boolean value) {
        try {
            parser.setFeature(name, value);
        }
        catch (SAXException e) {
            CommonPlugin.getPluginLog().logError("warning: Parser does not support feature (" + name + ")", e);
        }
    }

    public static void setProperty(XMLReader parser, String name, boolean value) {
        try {
            parser.setProperty(name, value);
        }
        catch (SAXException e) {
            CommonPlugin.getPluginLog().logError("warning: Parser does not support feature (" + name + ")", e);
        }
    }

    public String[] getXMLErrors(InputSource is) {
        ErrorHandlerImpl h;
        block5: {
            h = new ErrorHandlerImpl();
            try {
                XMLReader parser = this.createParser();
                if (parser == null) {
                    return new String[]{MessageFormat.format(Messages.SAXValidator_UnableToInstantiateMessage, DEFAULT_SAX_PARSER_CLASS_NAME)};
                }
                parser.setErrorHandler(h);
                parser.parse(is);
            }
            catch (SAXException e) {
                if (h.errors.isEmpty()) {
                    return new String[]{String.valueOf(Messages.SAXValidator_SAXExceptionMessage) + ":0:0", e.getMessage()};
                }
            }
            catch (IOException e) {
                if (!h.errors.isEmpty()) break block5;
                return new String[]{String.valueOf(Messages.SAXValidator_IOExceptionMessage) + ":0:0", e.getMessage()};
            }
        }
        return h.errors.toArray(new String[0]);
    }

    public String[] getXMLErrors(Reader reader) {
        InputSource inSource = new InputSource(reader);
        return this.getXMLErrors(inSource);
    }

    String getCatalog() {
        Bundle b = Platform.getBundle((String)"org.jboss.tools.common");
        String location = Platform.getStateLocation((Bundle)b).toString().replace('\\', '/');
        if (!location.endsWith("/")) {
            location = String.valueOf(location) + "/";
        }
        String urlString = null;
        URL url = null;
        try {
            url = Platform.resolve((URL)b.getEntry("/"));
            urlString = url.toString();
            if (!urlString.endsWith("/")) {
                urlString = String.valueOf(urlString) + "/";
            }
            urlString = String.valueOf(urlString) + "schemas";
        }
        catch (IOException e) {
            CommonPlugin.getPluginLog().logError(e);
        }
        File f1 = new File(String.valueOf(url.getFile()) + "/schemas/catalog.xml");
        File f2 = new File(String.valueOf(location) + "schemas/catalog.xml");
        if (f2.exists()) {
            return "file:///" + location + "schemas/catalog.xml";
        }
        FileUtil.copyDir(f1.getParentFile(), f2.getParentFile(), true);
        String text = FileUtil.readFile(f2);
        while (text.indexOf("%install%") >= 0) {
            int i = text.indexOf("%install%");
            text = String.valueOf(text.substring(0, i)) + urlString + text.substring(i + 9);
        }
        FileUtil.writeFile(f2, text);
        return "file:///" + location + "schemas/catalog.xml";
    }
}

