/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEntityResolver
implements EntityResolver {
    private static final Properties publicEntities = new Properties();
    private static final Properties systemEntities = new Properties();
    boolean deactivate = true;

    public static void registerPublicEntity(String publicId, String url) {
        publicEntities.setProperty(publicId, url);
    }

    public static void registerPublicEntity(String publicId, Class<?> loader, String resourceName) throws IOException {
        URL url = XMLEntityResolver.resolve(loader, resourceName);
        if (url != null) {
            XMLEntityResolver.registerPublicEntity(publicId, url.toString());
        }
    }

    public static void registerSystemEntity(String systemId, String url) {
        systemEntities.setProperty(systemId, url);
    }

    public static void registerSystemEntity(String systemId, Class<?> loader, String resourceName) throws IOException {
        URL url = XMLEntityResolver.resolve(loader, resourceName);
        if (url != null) {
            XMLEntityResolver.registerSystemEntity(systemId, url.toString());
        }
    }

    static URL resolve(Class<?> loader, String resourceName) throws IOException {
        URL url = loader.getResource(resourceName);
        return url == null ? null : FileLocator.resolve((URL)url);
    }

    public static XMLEntityResolver getInstance() {
        return new XMLEntityResolver();
    }

    private XMLEntityResolver() {
    }

    public void setDeactivate(boolean b) {
        this.deactivate = b;
    }

    public boolean isResolved(String publicId, String systemId) {
        String url;
        return publicId != null ? (url = publicEntities.getProperty(publicId)) != null : systemId != null && (url = systemEntities.getProperty(systemId)) != null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String url;
        InputSource source = null;
        boolean ok = false;
        if (publicId != null && (url = publicEntities.getProperty(publicId)) != null) {
            source = new InputSource(url);
            source.setPublicId(publicId);
            ok = true;
        }
        if (!ok && systemId != null && (url = systemEntities.getProperty(systemId)) != null) {
            source = new InputSource(url);
            source.setSystemId(systemId);
        }
        if (this.deactivate && systemId != null && source == null && systemId.toLowerCase().endsWith(".dtd")) {
            source = new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
        }
        return source;
    }
}

