/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.tools.common.zip.IZipEntryVisitor;
import org.jboss.tools.common.zip.ZipArchive;

public class UnzipOperation {
    File zipFile;
    public static final int BUFFER_SIZE = 4096;

    public UnzipOperation(String zipFile) {
        this(new File(zipFile));
    }

    public UnzipOperation(File zipFile) {
        this.zipFile = zipFile;
    }

    public void execute(File destination) throws IOException {
        ZipArchive archive = new ZipArchive(this.zipFile);
        archive.acceptVisitor(new UnzipEntryVisitor(destination));
    }

    public void execute(String destination) throws IOException {
        this.execute(new File(destination));
    }

    public void execute(File destination, String filter) throws IOException {
        ZipArchive archive = new ZipArchive(this.zipFile);
        archive.acceptVisitor(new FilteredZipEntryVisitor(filter, new UnzipEntryVisitor(destination)));
    }

    public void execute(String destination, String filter) throws IOException {
        this.execute(new File(destination, filter));
    }

    public static class FilteredZipEntryVisitor
    implements IZipEntryVisitor {
        private String filter;
        private IZipEntryVisitor visitor;

        public FilteredZipEntryVisitor(String filter, IZipEntryVisitor visitor) {
            this.filter = filter;
            this.visitor = visitor;
        }

        public void visiteDirectoryEntry(ZipFile zipFile, ZipEntry dir) throws IOException {
            if (dir.getName().matches(this.filter)) {
                this.visitor.visiteDirectoryEntry(zipFile, dir);
            }
        }

        public void visiteFileEntry(ZipFile zipFile, ZipEntry file) throws IOException {
            if (file.getName().matches(this.filter)) {
                this.visitor.visiteFileEntry(zipFile, file);
            }
        }
    }

    public static class UnzipEntryVisitor
    implements IZipEntryVisitor {
        private File destination;

        public UnzipEntryVisitor(File destination) {
            this.destination = destination;
        }

        public void visiteDirectoryEntry(ZipFile zipFIle, ZipEntry dir) throws IOException {
            File entryDir = new File(this.destination, dir.getName());
            entryDir.mkdirs();
        }

        public void visiteFileEntry(ZipFile zipFile, ZipEntry file) throws IOException {
            File outputFile = new File(this.destination, file.getName());
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile), 4096);
            BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(file));
            byte[] buff = new byte[4096];
            int n = -1;
            while ((n = in.read(buff, 0, buff.length)) > -1) {
                out.write(buff, 0, n);
            }
            out.flush();
        }
    }
}

