/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.htmlcss.LinkElementAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.URLModelProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.GlobalELReferenceList;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.IIncludedContextSupport;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.el.KbELReference;
import org.jboss.tools.jst.web.kb.include.IncludeContextBuilder;
import org.jboss.tools.jst.web.kb.internal.FaceletPageContextImpl;
import org.jboss.tools.jst.web.kb.internal.JspContextImpl;
import org.jboss.tools.jst.web.kb.internal.ResourceBundle;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.NameSpace;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContextFactory
implements IResourceChangeListener {
    private static PageContextFactory fInstance;
    private static final String XHTML_TAG_LIB_URI = "http://www.w3.org/1999/xhtml";
    public static final String XML_PAGE_CONTEXT_TYPE = "XML_PAGE_CONTEXT_TYPE";
    public static final String JSP_PAGE_CONTEXT_TYPE = "JSP_PAGE_CONTEXT_TYPE";
    public static final String FACELETS_PAGE_CONTEXT_TYPE = "FACELETS_PAGE_CONTEXT_TYPE";
    private static final String JAVA_PROPERTIES_CONTENT_TYPE = "org.eclipse.jdt.core.javaProperties";
    private Map<IFile, ELContext> cache = new HashMap<IFile, ELContext>();
    private static final String DOLLAR_PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final String SHARP_PREFIX = "#{";
    public static final String CONTEXT_PATH_EXPRESSION = "^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}";

    public static final PageContextFactory getInstance() {
        if (fInstance != null) {
            return fInstance;
        }
        fInstance = new PageContextFactory();
        return fInstance;
    }

    private PageContextFactory() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ELContext getSavedContext(IFile resource) {
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            return this.cache.get(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConvext(ELContext context) {
        if (context != null && context.getResource() != null) {
            Map<IFile, ELContext> map = this.cache;
            synchronized (map) {
                this.cache.put(context.getResource(), context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ELContext removeSavedContext(IFile resource) {
        ELContext removedContext = null;
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            removedContext = this.cache.remove(resource);
        }
        return removedContext;
    }

    public static ELContext createPageContext(IFile file) {
        return PageContextFactory.createPageContext(file, null);
    }

    public static ELContext createPageContext(IFile file, String contextType) {
        return PageContextFactory.getInstance().createPageContext(file, null, contextType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IFile file) {
        if (file == null) {
            return;
        }
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            ELContext removedContext = this.removeSavedContext(file);
            if (removedContext == null || removedContext.getResource() == null) {
                return;
            }
            ELContext[] contexts = this.cache.values().toArray(new ELContext[0]);
            if (contexts != null) {
                ELContext[] eLContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ELContext context = eLContextArray[n2];
                    if (this.isDependencyContext(context, file)) {
                        this.removeSavedContext(file);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IProject project) {
        if (project == null) {
            return;
        }
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            IFile[] files = this.cache.keySet().toArray(new IFile[0]);
            if (files != null) {
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    if (project.equals((Object)file.getProject())) {
                        this.cleanUp(file);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IResourceDelta delta) {
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            if (this.cache.size() == 0) {
                return;
            }
            if (!this.checkDelta(delta)) {
                return;
            }
            this.processDelta(delta);
        }
    }

    private ELContext createPropertiesContext(IFile file) {
        ELContextImpl context = new ELContextImpl();
        context.setResource(file);
        context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)file));
        String content = FileUtil.getContentFromEditorOrFile((IFile)file);
        int startEl = content.indexOf(SHARP_PREFIX);
        if (startEl < 0) {
            startEl = content.indexOf(DOLLAR_PREFIX);
        }
        if (startEl > -1) {
            ELParser parser = ELParserUtil.getJbossFactory().createParser();
            ELModel model = parser.parse(content);
            List errors = model.getSyntaxErrors();
            for (ELInstance instance : model.getInstances()) {
                for (ELInvocationExpression ie : instance.getExpression().getInvocations()) {
                    KbELReference elReference = new KbELReference();
                    elReference.setResource(file);
                    elReference.setEl(new ELExpression[]{ie});
                    elReference.setLength(ie.getLength());
                    elReference.setStartPosition(0);
                    ArrayList<SyntaxError> elErrors = new ArrayList<SyntaxError>();
                    for (SyntaxError error : errors) {
                        if (error.getPosition() < ie.getStartPosition() || error.getPosition() > ie.getEndPosition()) continue;
                        elErrors.add(error);
                    }
                    elReference.setSyntaxErrors(elErrors);
                    context.addELReference((ELReference)elReference);
                }
            }
        }
        return context;
    }

    private ELContext createJavaContext(IFile file) {
        ELContextImpl context = new ELContextImpl();
        context.setResource(file);
        context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)file));
        String content = FileUtil.getContentFromEditorOrFile((IFile)file);
        FastJavaPartitionScanner scaner = new FastJavaPartitionScanner();
        Document document = new Document(content);
        scaner.setRange((IDocument)document, 0, document.getLength());
        IToken token = scaner.nextToken();
        while (token != null && token != Token.EOF) {
            if ("__java_string".equals(token.getData())) {
                int length = scaner.getTokenLength();
                int offset = scaner.getTokenOffset();
                String value = null;
                try {
                    value = document.get(offset, length);
                }
                catch (BadLocationException e) {
                    WebKbPlugin.getDefault().logError(e);
                    return null;
                }
                if (value.indexOf(123) > -1) {
                    int startEl = value.indexOf(SHARP_PREFIX);
                    if (startEl == -1) {
                        startEl = value.indexOf(DOLLAR_PREFIX);
                    }
                    if (startEl > -1) {
                        ELParser parser = ELParserUtil.getJbossFactory().createParser();
                        ELModel model = parser.parse(value);
                        List is = model.getInstances();
                        KbELReference elReference = new KbELReference();
                        elReference.setResource(file);
                        elReference.setEl(is);
                        elReference.setLength(value.length());
                        elReference.setStartPosition(offset);
                        elReference.setSyntaxErrors(model.getSyntaxErrors());
                        context.addELReference((ELReference)elReference);
                    }
                }
            }
            token = scaner.nextToken();
        }
        return context;
    }

    private ELContext createPageContext(IFile file, List<String> parents, String defaultContextType) {
        ELContext context;
        boolean isContextCachingAllowed;
        block23: {
            String typeId;
            isContextCachingAllowed = !EclipseUIUtil.isOpenInActiveEditor((IFile)file) && file != null;
            ELContext eLContext = context = isContextCachingAllowed ? this.getSavedContext(file) : null;
            if (context != null) {
                return context;
            }
            if (file == null) {
                return this.createContextInstanceOfType(defaultContextType);
            }
            IContentType type = IDE.getContentType((IFile)file);
            String string = typeId = type == null ? null : type.getId();
            if ("org.eclipse.jdt.core.javaSource".equalsIgnoreCase(typeId)) {
                context = this.createJavaContext(file);
            } else if (JAVA_PROPERTIES_CONTENT_TYPE.equalsIgnoreCase(typeId)) {
                context = this.createPropertiesContext(file);
            } else {
                IStructuredModel model;
                block20: {
                    IDOMDocument document;
                    block21: {
                        block22: {
                            IModelManager manager = StructuredModelManager.getModelManager();
                            if (manager == null) {
                                return context;
                            }
                            model = null;
                            model = manager.getModelForRead(file);
                            if (!(model instanceof IDOMModel)) break block20;
                            IDOMModel domModel = (IDOMModel)model;
                            document = domModel.getDocument();
                            ELContext eLContext2 = context = defaultContextType == null ? this.createPageContextInstance(domModel.getContentTypeIdentifier()) : this.createContextInstanceOfType(defaultContextType);
                            if (context != null) break block21;
                            if (model == null) break block22;
                            model.releaseFromRead();
                        }
                        return null;
                    }
                    try {
                        context.setResource(file);
                        context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)file));
                        if (context instanceof JspContextImpl && !(context instanceof FaceletPageContextImpl)) {
                            this.fillJSPNameSpaces((JspContextImpl)context);
                        }
                        this.fillContextForChildNodes((IDOMNode)document, context, parents);
                    }
                    catch (CoreException e) {
                        WebKbPlugin.getDefault().logError(e);
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        try {
                            WebKbPlugin.getDefault().logError(e);
                            break block23;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (model != null) {
                                model.releaseFromRead();
                            }
                        }
                    }
                }
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        if (context != null && isContextCachingAllowed) {
            this.saveConvext(context);
        }
        return context;
    }

    private ELContext createPageContextInstance(String contentType) {
        String contextType = IncludeContextBuilder.getContextType(contentType);
        return this.createContextInstanceOfType(contextType);
    }

    private ELContext createContextInstanceOfType(String contextType) {
        if (JSP_PAGE_CONTEXT_TYPE.equals(contextType)) {
            return new JspContextImpl();
        }
        if (FACELETS_PAGE_CONTEXT_TYPE.equals(contextType)) {
            return new FaceletPageContextImpl();
        }
        return new XmlContextImpl();
    }

    private void fillJSPNameSpaces(JspContextImpl context) {
        TLDCMDocumentManager manager = TaglibController.getTLDCMDocumentManager((IDocument)context.getDocument());
        List trackers = manager == null ? null : manager.getCMDocumentTrackers(context.getDocument().getLength() - 1);
        int i = 0;
        while (trackers != null && i < trackers.size()) {
            String uri;
            TaglibTracker tt = (TaglibTracker)trackers.get(i);
            String prefix = tt.getPrefix() == null ? null : tt.getPrefix().trim();
            String string = uri = tt.getURI() == null ? null : tt.getURI().trim();
            if (prefix != null && prefix.length() > 0 && uri != null && uri.length() > 0) {
                Region region = new Region(0, context.getDocument().getLength());
                NameSpace nameSpace = new NameSpace(uri, prefix, TagLibraryManager.getLibraries(context.getResource().getProject(), uri));
                context.addNameSpace((IRegion)region, nameSpace);
            }
            ++i;
        }
    }

    private void fillContextForChildNodes(IDOMNode parent, ELContext context, List<String> parents) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMNode) {
                this.fillContextForNode((IDOMNode)child, context, parents);
                this.fillContextForChildNodes((IDOMNode)child, context, parents);
            }
            ++i;
        }
    }

    private void fillContextForNode(IDOMNode node, ELContext context, List<String> parents) {
        if (!(context instanceof FaceletPageContextImpl) && !(node instanceof IDOMElement)) {
            return;
        }
        if (context instanceof XmlContextImpl) {
            XmlContextImpl xmlContext = (XmlContextImpl)context;
            this.fillElReferencesForNode(node, xmlContext);
            if (node instanceof IDOMElement) {
                this.fillXMLNamespacesForNode((Element)((IDOMElement)node), xmlContext);
            }
        }
        if ((context instanceof JspContextImpl || context instanceof FaceletPageContextImpl) && node instanceof IDOMElement) {
            this.fillVarsForNode((IDOMElement)node, (ELContextImpl)context);
        }
        boolean cfr_ignored_0 = context instanceof FaceletPageContextImpl;
        if (context instanceof JspContextImpl && node instanceof IDOMElement) {
            this.fillResourceBundlesForNode((IDOMElement)node, (JspContextImpl)context);
        }
        if (context instanceof IPageContext && node instanceof IDOMElement) {
            this.fillAdditionalInfoForNode((IDOMElement)node, (IPageContext)context, parents);
        }
    }

    private void fillVarsForNode(IDOMElement node, ELContextImpl context) {
        Var var = ElVarSearcher.findVar((Node)node, (ELParserFactory)ELParserUtil.getJbossFactory());
        if (var != null) {
            int start = node.getStartOffset();
            int length = node.getLength();
            start = node.getStartOffset();
            length = node.hasEndTag() ? node.getEndStructuredDocumentRegion().getEnd() : ((IDOMNode)node.getOwnerDocument()).getEndOffset() - 1 - start;
            context.addVar(new Region(start, length), var);
        }
    }

    private void fillElReferencesForNode(IDOMNode node, XmlContextImpl context) {
        if (1 == node.getNodeType() || 3 == node.getNodeType()) {
            IStructuredDocumentRegion regionNode = node.getFirstStructuredDocumentRegion();
            if (regionNode == null) {
                return;
            }
            ITextRegionList regions = regionNode.getRegions();
            int i = 0;
            while (i < regions.size()) {
                String text;
                ITextRegion region = regions.get(i);
                if ((region.getType() == "XML_TAG_ATTRIBUTE_VALUE" || region.getType() == "XML_CONTENT") && (text = regionNode.getFullText(region)).indexOf("{") > -1) {
                    int offset = regionNode.getStartOffset() + region.getStart();
                    int startEl = text.indexOf(SHARP_PREFIX);
                    if (startEl == -1) {
                        startEl = text.indexOf(DOLLAR_PREFIX);
                    }
                    if (startEl > -1) {
                        ELParser parser = ELParserUtil.getJbossFactory().createParser();
                        ELModel model = parser.parse(text);
                        List is = model.getInstances();
                        KbELReference elReference = new KbELReference();
                        elReference.setResource(context.getResource());
                        elReference.setEl(is);
                        elReference.setLength(text.length());
                        elReference.setStartPosition(offset);
                        elReference.setSyntaxErrors(model.getSyntaxErrors());
                        context.addELReference(elReference);
                    }
                }
                ++i;
            }
        }
    }

    private void fillAdditionalInfoForNode(IDOMElement node, IPageContext context, List<String> parents) {
        String prefix = node.getPrefix() == null ? "" : node.getPrefix();
        String tagName = node.getLocalName();
        Map<String, List<INameSpace>> nsMap = context.getNameSpaces(node.getStartOffset());
        String[] uris = PageContextFactory.getUrisByPrefix(nsMap, prefix);
        if (uris != null) {
            String[] stringArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String[] includeAttributes;
                String uri = stringArray[n2];
                if (context instanceof IIncludedContextSupport && (includeAttributes = IncludeContextBuilder.getIncludeAttributes(uri, tagName)) != null) {
                    ArrayList<String> newParentList = parents == null ? new ArrayList<String>() : new ArrayList<String>(parents);
                    newParentList.add(context.getResource().getFullPath().toString());
                    String[] stringArray2 = includeAttributes;
                    int n4 = includeAttributes.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ELContext includedContext;
                        IFile file;
                        String attr = stringArray2[n3];
                        String fileName = node.getAttribute(attr);
                        if (fileName != null && fileName.trim().length() != 0 && (file = PageContextFactory.getFileFromProject(fileName, context.getResource())) != null && this.checkCycling(parents, file) && (includedContext = this.createPageContext(file, newParentList, null)) != null) {
                            ((IIncludedContextSupport)((Object)context)).addIncludedContext(includedContext);
                        }
                        ++n3;
                    }
                }
                if (context instanceof ICSSContainerSupport) {
                    if (IncludeContextBuilder.isCSSStyleSheetContainer(uri, tagName)) {
                        this.fillCSSStyleSheetFromElement(node, (ICSSContainerSupport)((Object)context));
                    } else {
                        String[] cssAttributes = IncludeContextBuilder.getCSSStyleSheetAttributes(uri, tagName);
                        if (cssAttributes != null) {
                            String[] stringArray3 = cssAttributes;
                            n3 = cssAttributes.length;
                            int n5 = 0;
                            while (n5 < n3) {
                                String attr = stringArray3[n5];
                                this.fillCSSStyleSheetFromAttribute(node, attr, (ICSSContainerSupport)((Object)context));
                                ++n5;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private boolean checkCycling(List<String> parents, IFile resource) {
        String resourceId = resource.getFullPath().toString();
        if (parents != null) {
            for (String parentId : parents) {
                if (!resourceId.equals(parentId)) continue;
                return false;
            }
        }
        return true;
    }

    private void fillXMLNamespacesForNode(Element node, XmlContextImpl context) {
        NamedNodeMap attrs = node.getAttributes();
        boolean mainNnIsRedefined = false;
        int j = 0;
        while (attrs != null && j < attrs.getLength()) {
            Attr a = (Attr)attrs.item(j);
            String name = a.getName();
            if (name.startsWith("xmlns:") || name.equals("xmlns")) {
                String prefix = name.startsWith("xmlns:") ? name.substring("xmlns:".length()) : "";
                String uri = a.getValue();
                prefix = prefix == null ? null : prefix.trim();
                String string = uri = uri == null ? null : uri.trim();
                if (!XHTML_TAG_LIB_URI.equalsIgnoreCase(uri) && prefix != null && uri != null && uri.length() > 0) {
                    IDOMElement domElement;
                    int start = ((IndexedRegion)node).getStartOffset();
                    int length = ((IndexedRegion)node).getLength();
                    IDOMElement iDOMElement = domElement = node instanceof IDOMElement ? (IDOMElement)node : null;
                    if (domElement != null) {
                        start = domElement.getStartOffset();
                        length = domElement.hasEndTag() ? domElement.getEndStructuredDocumentRegion().getEnd() : ((IDOMNode)node.getOwnerDocument()).getEndOffset() - 1 - start;
                    }
                    Region region = new Region(start, length);
                    NameSpace nameSpace = new NameSpace(uri, prefix, TagLibraryManager.getLibraries(context.getResource().getProject(), uri));
                    context.addNameSpace((IRegion)region, nameSpace);
                    if (prefix.length() == 0) {
                        mainNnIsRedefined = true;
                    }
                    if (context instanceof FaceletPageContextImpl && "http://java.sun.com/jsf/facelets".equals(uri) && !mainNnIsRedefined) {
                        nameSpace = new NameSpace("http://www.w3.org/1999/xhtml/facelets", "", TagLibraryManager.getLibraries(context.getResource().getProject(), "http://www.w3.org/1999/xhtml/facelets"));
                        context.addNameSpace((IRegion)region, nameSpace);
                    }
                }
            }
            ++j;
        }
    }

    private void fillResourceBundlesForNode(IDOMElement node, JspContextImpl context) {
        String var;
        String name = node.getNodeName();
        if (name == null) {
            return;
        }
        if (!name.endsWith("loadBundle")) {
            return;
        }
        if (name.indexOf(58) == -1) {
            return;
        }
        String prefix = name.substring(0, name.indexOf(58));
        Map<String, List<INameSpace>> ns = context.getNameSpaces(node.getStartOffset());
        if (!this.containsPrefix(ns, prefix)) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        String basename = attributes.getNamedItem("basename") == null ? null : attributes.getNamedItem("basename").getNodeValue();
        String string = var = attributes.getNamedItem("var") == null ? null : attributes.getNamedItem("var").getNodeValue();
        if (basename == null || basename.length() == 0 || var == null || var.length() == 0) {
            return;
        }
        context.addResourceBundle(new ResourceBundle(basename, var));
    }

    private void fillCSSStyleSheetFromAttribute(IDOMElement node, String attribute, ICSSContainerSupport context) {
        CSSStyleSheetDescriptor descr = this.getSheetForTagAttribute((Node)node, attribute);
        if (descr != null) {
            context.addCSSStyleSheetDescriptor(descr);
        }
    }

    private void fillCSSStyleSheetFromElement(IDOMElement node, ICSSContainerSupport context) {
        CSSStyleSheet sheet = this.getSheetForTag((Node)node);
        if (sheet != null) {
            context.addCSSStyleSheetDescriptor(new CSSStyleSheetDescriptor(context.getResource().getFullPath().toString(), sheet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSSStyleSheetDescriptor getSheetForTagAttribute(Node stylesContainer, String attribute) {
        INodeNotifier notifier = (INodeNotifier)stylesContainer;
        CSSStyleSheet sheet = null;
        String source = null;
        INodeNotifier iNodeNotifier = notifier;
        synchronized (iNodeNotifier) {
            Object adapter = (IStyleSheetAdapter)notifier.getAdapterFor(IStyleSheetAdapter.class);
            if (!(adapter instanceof ExtendedLinkElementAdapter)) {
                notifier.removeAdapter((INodeAdapter)adapter);
                adapter = new ExtendedLinkElementAdapter((Element)stylesContainer, attribute);
                notifier.addAdapter((INodeAdapter)adapter);
            }
            if (adapter != null) {
                sheet = (CSSStyleSheet)adapter.getSheet();
                source = ((ExtendedLinkElementAdapter)((Object)adapter)).getSource();
            }
        }
        return sheet == null || source == null ? null : new CSSStyleSheetDescriptor(source, sheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSSStyleSheet getSheetForTag(Node stylesContainer) {
        INodeNotifier notifier = (INodeNotifier)stylesContainer;
        CSSStyleSheet sheet = null;
        INodeNotifier iNodeNotifier = notifier;
        synchronized (iNodeNotifier) {
            IStyleSheetAdapter adapter = (IStyleSheetAdapter)notifier.getAdapterFor(IStyleSheetAdapter.class);
            if (adapter != null) {
                sheet = (CSSStyleSheet)adapter.getSheet();
            }
        }
        return sheet;
    }

    private boolean containsPrefix(Map<String, List<INameSpace>> ns, String prefix) {
        for (List<INameSpace> n : ns.values()) {
            for (INameSpace nameSpace : n) {
                if (!prefix.equals(nameSpace.getPrefix())) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getUrisByPrefix(Map<String, List<INameSpace>> nsMap, String prefix) {
        String[] stringArray;
        if (nsMap == null || nsMap.isEmpty()) {
            return null;
        }
        HashSet<String> uris = new HashSet<String>();
        for (List<INameSpace> nsList : nsMap.values()) {
            for (INameSpace ns : nsList) {
                if (!prefix.equals(ns.getPrefix())) continue;
                uris.add(ns.getURI());
            }
        }
        if (uris.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prefix;
        } else {
            stringArray = uris.toArray(new String[uris.size()]);
        }
        return stringArray;
    }

    public static IFile getFileFromProject(String fileName, IFile documentFile) {
        if (documentFile == null || !documentFile.isAccessible()) {
            return null;
        }
        fileName = PageContextFactory.findAndReplaceElVariable(fileName);
        IProject project = documentFile.getProject();
        String name = Utils.trimFilePath((String)fileName);
        IPath currentPath = documentFile.getLocation().removeLastSegments(1);
        IFile member = null;
        StructureEdit se = StructureEdit.getStructureEditForRead((IProject)project);
        if (se == null) {
            return null;
        }
        WorkbenchComponent[] modules = se.getWorkbenchModules();
        int i = 0;
        while (i < modules.length) {
            if (name.startsWith("/")) {
                member = PageContextFactory.findFileByAbsolutePath(project, modules[i], name);
            } else {
                member = PageContextFactory.findFileByRelativePath(project, modules[i], currentPath, name);
                if (member == null && name.length() > 0) {
                    member = PageContextFactory.findFileByAbsolutePath(project, modules[i], "/" + name);
                }
            }
            if (member != null && member instanceof IFile && member.exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private static IFile findFileByRelativePath(IProject project, WorkbenchComponent module, IPath basePath, String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = PageContextFactory.findAndReplaceElVariable(path);
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        IPath projectPath = project.getLocation();
        IFile member = null;
        int i = 0;
        while (resources != null && i < resources.length) {
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            IPath webRootPath = projectPath.append(sourcePath);
            IPath relativePath = Utils.getRelativePath((IPath)webRootPath, (IPath)basePath);
            IPath filePath = relativePath.append(path);
            member = project.getFolder(sourcePath).getFile(filePath);
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1) {
                webRootPath = projectPath.append(runtimePath);
                relativePath = Utils.getRelativePath((IPath)webRootPath, (IPath)basePath);
                filePath = relativePath.append(path);
                member = project.getFolder(runtimePath).getFile(filePath);
                if (member.exists()) {
                    return member;
                }
            }
            ++i;
        }
        return null;
    }

    private static IFile findFileByAbsolutePath(IProject project, WorkbenchComponent module, String path) {
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        path = PageContextFactory.findAndReplaceElVariable(path);
        IFile member = null;
        int i = 0;
        while (resources != null && i < resources.length) {
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            member = project.getFolder(sourcePath).getFile(path);
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1 && (member = project.getFolder(runtimePath).getFile(path)).exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private static String findAndReplaceElVariable(String fileName) {
        ResourceReference[] sortedReferences;
        if (fileName != null) {
            fileName = fileName.replaceFirst(CONTEXT_PATH_EXPRESSION, "");
        }
        IPath workspacePath = Platform.getLocation();
        ResourceReference[] gResources = GlobalELReferenceList.getInstance().getAllResources(workspacePath);
        String result = fileName;
        ResourceReference[] resourceReferenceArray = sortedReferences = PageContextFactory.sortReferencesByScope(gResources);
        int n = sortedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference rf = resourceReferenceArray[n2];
            String dollarEl = DOLLAR_PREFIX + rf.getLocation() + SUFFIX;
            String sharpEl = SHARP_PREFIX + rf.getLocation() + SUFFIX;
            if (fileName.contains(dollarEl)) {
                result = result.replace(dollarEl, rf.getProperties());
            }
            if (fileName.contains(sharpEl)) {
                result = result.replace(sharpEl, rf.getProperties());
            }
            ++n2;
        }
        return result;
    }

    private static ResourceReference[] sortReferencesByScope(ResourceReference[] references) {
        ResourceReference[] sortedReferences = (ResourceReference[])references.clone();
        Arrays.sort(sortedReferences, new Comparator<ResourceReference>(){

            @Override
            public int compare(ResourceReference r1, ResourceReference r2) {
                return r1.getScope() - r2.getScope();
            }
        });
        return sortedReferences;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        this.cleanUp(event.getDelta());
    }

    private boolean checkDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if (resource instanceof IWorkspaceRoot) {
            IResourceDelta[] d = delta.getAffectedChildren();
            return d.length > 0 && this.checkDelta(d[0]);
        }
        return true;
    }

    private void processDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        int kind = delta.getKind();
        IResource resource = delta.getResource();
        if (resource instanceof IProject && kind == 2) {
            this.cleanUp((IProject)resource);
        } else if (resource instanceof IFile && (kind == 4 || kind == 1 || kind == 2 || kind == 256)) {
            this.cleanUp((IFile)resource);
        }
        IResourceDelta[] cs = delta.getAffectedChildren();
        int i = 0;
        while (cs != null && i < cs.length) {
            this.processDelta(cs[i]);
            ++i;
        }
    }

    private boolean isDependencyContext(ELContext context, IFile resource) {
        List<ELContext> includedContexts;
        if (resource.equals((Object)context.getResource())) {
            return true;
        }
        if (context instanceof IIncludedContextSupport && (includedContexts = ((IIncludedContextSupport)context).getIncludedContexts()) != null) {
            for (ELContext includedContext : includedContexts) {
                if (!this.isDependencyContext(includedContext, resource)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        Map<IFile, ELContext> map = this.cache;
        synchronized (map) {
            ELContext[] contexts = this.cache.values().toArray(new ELContext[0]);
            if (contexts != null) {
                ELContext[] eLContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ELContext context = eLContextArray[n2];
                    this.removeSavedContext(context.getResource());
                    ++n2;
                }
            }
        }
    }

    public static class CSSStyleSheetDescriptor {
        public CSSStyleSheet sheet;
        public String source;

        CSSStyleSheetDescriptor(String source, CSSStyleSheet sheet) {
            this.source = source;
            this.sheet = sheet;
        }
    }

    public static class ExtendedLinkElementAdapter
    extends LinkElementAdapter {
        private Element element;
        private String hrefAttrName;
        private String source = null;

        public ExtendedLinkElementAdapter(Element element, String hrefAttrName) {
            this.element = element;
            this.hrefAttrName = hrefAttrName;
        }

        public Element getElement() {
            return this.element;
        }

        public String getSource() {
            return this.source;
        }

        protected boolean isValidAttribute() {
            if (super.isValidAttribute()) {
                return true;
            }
            String href = this.getElement().getAttribute(this.hrefAttrName);
            return href != null && href.length() != 0;
        }

        public ICSSModel getModel() {
            if (super.isValidAttribute()) {
                this.source = this.getSourceFromAttribute("href");
            } else if (this.isValidAttribute()) {
                this.source = this.getSourceFromAttribute(this.hrefAttrName);
            } else {
                return null;
            }
            ICSSModel model = this.retrieveModel();
            this.setModel(model);
            return model;
        }

        private String getSourceFromAttribute(String hrefAttributeName) {
            String hrefExtracted = PageContextFactory.findAndReplaceElVariable(this.element.getAttribute(this.hrefAttrName));
            return hrefExtracted;
        }

        private ICSSModel retrieveModel() {
            IStructuredModel newModel;
            IModelProvideAdapter adapter;
            block10: {
                block9: {
                    if (!this.isValidAttribute() || this.source == null) {
                        return null;
                    }
                    IDOMModel baseModel = ((IDOMNode)this.element).getModel();
                    if (baseModel == null) {
                        return null;
                    }
                    String id = baseModel.getId();
                    if (!(id instanceof String)) {
                        return null;
                    }
                    adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
                    URLModelProvider provider = new URLModelProvider();
                    newModel = provider.getModelForRead((IStructuredModel)baseModel, this.source);
                    if (newModel != null) break block9;
                    return null;
                }
                if (newModel instanceof ICSSModel) break block10;
                newModel.releaseFromRead();
                return null;
            }
            try {
                if (adapter != null) {
                    adapter.modelProvided(newModel);
                }
                return (ICSSModel)newModel;
            }
            catch (UnsupportedEncodingException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            return null;
        }
    }
}

