/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.include;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.jboss.tools.jst.web.kb.include.IncludeContextDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeContextBuilder
extends RegistryReader {
    public static final String PL_INCLUDE = "KbIncludeContext";
    public static final String TAG_INCLUDE = "include";
    public static final String TAG_TAG = "tag";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_CONTEXTTYPE = "contexttype";
    public static final String TAG_CONTENTTYPE = "contenttype";
    public static final String TAG_CSSHOLDER = "cssholder";
    public static final String ATT_ID = "id";
    public static final String ATT_URI = "uri";
    public static final String ATT_NAME = "name";
    protected String fTargetContributionElement;
    private static IncludeContextBuilder fInstance;
    private List<IncludeContextDefinition> fIncludeContextDefs = null;
    private IncludeContextDefinition fCurrentIncludeDefinition = null;

    public static synchronized IncludeContextBuilder getInstance() {
        if (fInstance == null) {
            fInstance = new IncludeContextBuilder();
        }
        return fInstance;
    }

    public static String getId(IConfigurationElement element) {
        String value = element.getAttribute(ATT_ID);
        return value;
    }

    public static String getUri(IConfigurationElement element) {
        String value = element.getAttribute(ATT_URI);
        return value;
    }

    public static String getName(IConfigurationElement element) {
        String value = element.getAttribute(ATT_NAME);
        return value;
    }

    private void processIncludeContextElement(IConfigurationElement element) {
        String theUri = IncludeContextBuilder.getUri(element);
        String string = theUri = theUri == null ? "" : theUri;
        if (this.fIncludeContextDefs == null) {
            this.fIncludeContextDefs = new ArrayList<IncludeContextDefinition>();
        }
        this.fCurrentIncludeDefinition = this.getIncludeContextDefinition(theUri);
        if (this.fCurrentIncludeDefinition == null) {
            this.fCurrentIncludeDefinition = new IncludeContextDefinition(theUri);
            this.fIncludeContextDefs.add(this.fCurrentIncludeDefinition);
        }
    }

    private IncludeContextDefinition getIncludeContextDefinition(String uri) {
        if (this.fIncludeContextDefs == null || uri == null) {
            return null;
        }
        for (IncludeContextDefinition def : this.fIncludeContextDefs) {
            if (!uri.equals(def.getUri())) continue;
            return def;
        }
        return null;
    }

    private boolean processTagElement(IConfigurationElement element) {
        String theName = IncludeContextBuilder.getName(element);
        if (this.fCurrentIncludeDefinition != null && theName != null) {
            return this.fCurrentIncludeDefinition.addTag(theName, element);
        }
        return false;
    }

    private void processAttributeElement(IConfigurationElement element) {
        String theName = IncludeContextBuilder.getName(element);
        if (this.fCurrentIncludeDefinition != null && theName != null) {
            this.fCurrentIncludeDefinition.addTagAttribute(theName, element);
        }
    }

    private void processContextTypeElement(IConfigurationElement element) {
        String theId = IncludeContextBuilder.getId(element);
        if (this.fCurrentIncludeDefinition != null && theId != null) {
            this.fCurrentIncludeDefinition.addContextType(theId, element);
        }
    }

    private boolean processContentTypeElement(IConfigurationElement element) {
        String theId = IncludeContextBuilder.getId(element);
        if (this.fCurrentIncludeDefinition != null && theId != null) {
            return this.fCurrentIncludeDefinition.addContentType(theId, element);
        }
        return false;
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_INCLUDE) || tag.equals(TAG_CSSHOLDER)) {
            this.processIncludeContextElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_TAG)) {
            this.processTagElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_ATTRIBUTE)) {
            this.processAttributeElement(element);
            return true;
        }
        if (tag.equals(TAG_CONTEXTTYPE)) {
            this.processContextTypeElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
            return true;
        }
        if (tag.equals(TAG_CONTENTTYPE)) {
            return this.processContentTypeElement(element);
        }
        return false;
    }

    private void initCache() {
        if (this.fIncludeContextDefs == null) {
            this.readContributions(TAG_INCLUDE, PL_INCLUDE);
        }
    }

    protected void readContributions(String element, String extensionPoint) {
        this.fTargetContributionElement = element;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, "org.jboss.tools.jst.web.kb", extensionPoint);
    }

    public List<IncludeContextDefinition> getIncludeContextDefinitions() {
        this.initCache();
        return this.fIncludeContextDefs;
    }

    public static String[] getIncludeAttributes(String uri, String tagName) {
        if (uri == null) {
            return null;
        }
        List<IncludeContextDefinition> defs = IncludeContextBuilder.getInstance().getIncludeContextDefinitions();
        if (defs == null) {
            return null;
        }
        ArrayList<String> attrs = new ArrayList<String>();
        for (IncludeContextDefinition def : defs) {
            String[] defAttrs;
            if (!uri.equals(def.getUri()) || (defAttrs = def.getIncludeTagAttributes(tagName)) == null) continue;
            String[] stringArray = defAttrs;
            int n = defAttrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                attrs.add(attr);
                ++n2;
            }
        }
        return attrs.size() == 0 ? null : attrs.toArray(new String[attrs.size()]);
    }

    public static String getContextType(String contentType) {
        if (contentType == null) {
            return null;
        }
        List<IncludeContextDefinition> defs = IncludeContextBuilder.getInstance().getIncludeContextDefinitions();
        if (defs == null) {
            return null;
        }
        for (IncludeContextDefinition def : defs) {
            String contextType = def.getContextType(contentType);
            if (contextType == null) continue;
            return contextType;
        }
        return null;
    }

    public static boolean isCSSStyleSheetContainer(String uri, String tagName) {
        if (uri == null) {
            return false;
        }
        List<IncludeContextDefinition> defs = IncludeContextBuilder.getInstance().getIncludeContextDefinitions();
        if (defs == null) {
            return false;
        }
        boolean isHolder = false;
        for (IncludeContextDefinition def : defs) {
            String[] defTags;
            if (!uri.equals(def.getUri()) || (defTags = def.getCSSTags()) == null) continue;
            String[] stringArray = defTags;
            int n = defTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tagName.equals(tag) || "".equals(uri) && tagName.equalsIgnoreCase(tag)) {
                    isHolder = true;
                    String[] attrs = def.getCSSTagAttributes(tagName);
                    isHolder ^= attrs != null && attrs.length > 0;
                }
                ++n2;
            }
        }
        return isHolder;
    }

    public static String[] getCSSStyleSheetAttributes(String uri, String tagName) {
        if (uri == null) {
            return null;
        }
        List<IncludeContextDefinition> defs = IncludeContextBuilder.getInstance().getIncludeContextDefinitions();
        if (defs == null) {
            return null;
        }
        ArrayList<String> attrs = new ArrayList<String>();
        for (IncludeContextDefinition def : defs) {
            String[] defAttrs;
            if (!uri.equals(def.getUri()) || (defAttrs = def.getCSSTagAttributes(tagName)) == null) continue;
            String[] stringArray = defAttrs;
            int n = defAttrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                attrs.add(attr);
                ++n2;
            }
        }
        return attrs.size() == 0 ? null : attrs.toArray(new String[attrs.size()]);
    }
}

