/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.include;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jboss.tools.jst.web.kb.include.IncludeContextBuilder;

public class IncludeContextDefinition {
    private String fUri;
    private Map<String, Set<String>> fIncludeTags;
    private Map<String, Set<String>> fCSSTags;
    private Map<String, Set<String>> fContexts;
    private static final String[] EMPTY_CHILDREN = new String[0];

    public IncludeContextDefinition(String uri) {
        this.fUri = uri;
    }

    public String getUri() {
        return this.fUri;
    }

    public void setUri(String uri) {
        this.fUri = uri;
    }

    public boolean addTag(String tagName, IConfigurationElement element) {
        if ("".equals(this.fUri)) {
            tagName = tagName.toLowerCase();
        }
        if (this.isInParentElements(element, "include")) {
            this.addIncludeTag(tagName, element);
            return true;
        }
        if (this.isInParentElements(element, "cssholder")) {
            this.addCSSTag(tagName, element);
            return true;
        }
        return false;
    }

    private void addIncludeTag(String tagName, IConfigurationElement element) {
        Set<String> tagSet;
        if (this.fIncludeTags == null) {
            this.fIncludeTags = new HashMap<String, Set<String>>();
        }
        if ((tagSet = this.fIncludeTags.get(tagName)) == null) {
            tagSet = new HashSet<String>();
            this.fIncludeTags.put(tagName, tagSet);
        }
    }

    private void addCSSTag(String tagName, IConfigurationElement element) {
        Set<String> tagSet;
        if (this.fCSSTags == null) {
            this.fCSSTags = new HashMap<String, Set<String>>();
        }
        if ((tagSet = this.fCSSTags.get(tagName)) == null) {
            tagSet = new HashSet<String>();
            this.fCSSTags.put(tagName, tagSet);
        }
    }

    public void addTagAttribute(String attributeName, IConfigurationElement element) {
        IConfigurationElement parentElement;
        IConfigurationElement parentTagElement = null;
        if (element.getParent() instanceof IConfigurationElement && "tag".equals((parentElement = (IConfigurationElement)element.getParent()).getName())) {
            parentTagElement = parentElement;
        }
        String parentTagName = null;
        if (parentTagElement != null) {
            parentTagName = IncludeContextBuilder.getName(parentTagElement);
        }
        String string = parentTagName = parentTagName == null ? "" : parentTagName;
        if ("".equals(this.fUri)) {
            parentTagName = parentTagName.toLowerCase();
        }
        if (this.isInParentElements(element, "include")) {
            if (this.fIncludeTags.get(parentTagName) == null) {
                this.addIncludeTag(parentTagName, parentTagElement);
            }
            this.fIncludeTags.get(parentTagName).add(attributeName);
        } else if (this.isInParentElements(element, "cssholder")) {
            if (this.fCSSTags.get(parentTagName) == null) {
                this.addCSSTag(parentTagName, parentTagElement);
            }
            this.fCSSTags.get(parentTagName).add(attributeName);
        }
    }

    private boolean isInParentElements(IConfigurationElement element, String elementName) {
        Object parent = element.getParent();
        while (parent instanceof IConfigurationElement) {
            IConfigurationElement parentElement = (IConfigurationElement)parent;
            if (elementName.equals(parentElement.getName())) {
                return true;
            }
            parent = parentElement.getParent();
        }
        return false;
    }

    public void addContextType(String id, IConfigurationElement element) {
        Set<String> contextSet;
        if (this.fContexts == null) {
            this.fContexts = new HashMap<String, Set<String>>();
        }
        if ((contextSet = this.fContexts.get(id)) == null) {
            contextSet = new HashSet<String>();
            this.fContexts.put(id, contextSet);
        }
    }

    public boolean addContentType(String id, IConfigurationElement element) {
        IConfigurationElement parentElement;
        IConfigurationElement parentContextElement = null;
        if (element.getParent() instanceof IConfigurationElement && "contexttype".equals((parentElement = (IConfigurationElement)element.getParent()).getName())) {
            parentContextElement = parentElement;
        }
        String parentContextId = null;
        if (parentContextElement != null) {
            parentContextId = IncludeContextBuilder.getId(parentContextElement);
        }
        if (this.fContexts.get(parentContextId) == null) {
            return false;
        }
        this.fContexts.get(parentContextId).add(id);
        return true;
    }

    public String[] getIncludeTags() {
        return this.fIncludeTags == null ? EMPTY_CHILDREN : this.fIncludeTags.keySet().toArray(new String[this.fIncludeTags.size()]);
    }

    public String[] getCSSTags() {
        return this.fCSSTags == null ? EMPTY_CHILDREN : this.fCSSTags.keySet().toArray(new String[this.fCSSTags.size()]);
    }

    public String[] getIncludeTagAttributes(String tagName) {
        if ("".equals(this.fUri)) {
            tagName = tagName.toLowerCase();
        }
        Set<String> attrSet = this.fIncludeTags == null ? null : this.fIncludeTags.get(tagName);
        return attrSet == null ? EMPTY_CHILDREN : attrSet.toArray(new String[attrSet.size()]);
    }

    public String[] getCSSTagAttributes(String tagName) {
        if ("".equals(this.fUri)) {
            tagName = tagName.toLowerCase();
        }
        Set<String> attrSet = this.fCSSTags == null ? null : this.fCSSTags.get(tagName);
        return attrSet == null ? EMPTY_CHILDREN : attrSet.toArray(new String[attrSet.size()]);
    }

    public String getContextType(String contentType) {
        if (this.fContexts == null) {
            return null;
        }
        for (String contextType : this.fContexts.keySet()) {
            if (!this.fContexts.get(contextType).contains(contentType)) continue;
            return contextType;
        }
        return null;
    }
}

