/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.LibraryStorage;
import org.jboss.tools.jst.web.kb.internal.StaticLibraries;
import org.jboss.tools.jst.web.kb.internal.scanner.ClassPathMonitor;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeTagLibrary;
import org.jboss.tools.jst.web.kb.internal.validation.ProjectValidationContext;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KbProject
extends KbObject
implements IKbProject {
    IProject project;
    boolean isMock = false;
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    Map<IPath, LoadedDeclarations> sourcePaths2 = new HashMap<IPath, LoadedDeclarations>();
    private boolean isStorageResolved = false;
    Set<KbProject> dependsOn = new HashSet<KbProject>();
    Set<KbProject> usedBy = new HashSet<KbProject>();
    LibraryStorage libraries = new LibraryStorage();
    ProjectValidationContext validationContext;
    public long fullBuildTime;
    public List<Long> statistics;
    static String EXTERNAL_TOOL_BUILDER = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    List<Change> postponedChanges = null;
    public static final String KB_PROBLEM_MARKER_TYPE = "org.jboss.tools.jst.web.kb.kbproblemmarker";

    public void setMock() {
        this.isMock = true;
    }

    @Override
    public ITagLibrary[] getTagLibraries() {
        return this.libraries.getAllLibrariesArray();
    }

    @Override
    public ITagLibrary[] getTagLibraries(String uri) {
        ITagLibrary[] result = this.libraries.getLibrariesArray(uri);
        if (result == null || result.length == 0) {
            result = StaticLibraries.instance.getLibraries(uri);
        }
        return result;
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(KbBuilder.BUILDER_ID);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(KbBuilder.BUILDER_ID);
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public IKbProject getKbProject() {
        return this;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.setSourcePath(project.getFullPath());
        this.resource = project;
        this.classPath.init();
    }

    public void addKbProject(KbProject p) {
        if (this.dependsOn.contains(p)) {
            return;
        }
        this.dependsOn.add(p);
        p.addDependentKbProject(this);
        if (!p.isStorageResolved) {
            p.resolve();
        } else {
            Map<IPath, LoadedDeclarations> map = null;
            try {
                map = p.getAllDeclarations();
            }
            catch (CloneNotSupportedException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
            for (IPath source : map.keySet()) {
                LoadedDeclarations ds = map.get(source);
                this.registerComponents(ds, source);
            }
        }
    }

    public Set<KbProject> getKbProjects() {
        return this.dependsOn;
    }

    public void addDependentKbProject(KbProject p) {
        this.usedBy.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKbProject(KbProject p) {
        if (!this.dependsOn.contains(p)) {
            return;
        }
        p.usedBy.remove(this);
        this.dependsOn.remove(p);
        IPath[] ps = null;
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        }
        int i = 0;
        while (i < ps.length) {
            IPath pth = ps[i];
            if (p.getSourcePath().isPrefixOf(pth) || p.isPathLoaded(pth) && !EclipseResourceUtil.isJar((String)pth.toString())) {
                this.pathRemoved(pth);
            }
            ++i;
        }
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.isStorageResolved = true;
        }
    }

    @Override
    public void resolve() {
        this.resolveStorage(true);
    }

    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        this.isStorageResolved = true;
        this.postponeFiring();
        try {
            boolean b = this.getClassPath().update();
            if (b) {
                this.getClassPath().validateProjectDependencies();
            }
            File file = this.getStorageFile();
            Element root = null;
            if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
                this.loadProjectDependencies(root);
                if (XMLUtilities.getUniqueChild((Element)root, (String)"paths") != null) {
                    this.loadSourcePaths2(root);
                }
            }
            if (b) {
                this.getClassPath().process();
            }
            if (root != null) {
                this.getValidationContext().load(root);
            }
        }
        finally {
            this.fireChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.classPath.clean();
        this.postponeFiring();
        IPath[] ps = null;
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            ps = this.sourcePaths2.keySet().toArray(new IPath[0]);
        }
        int i = 0;
        while (i < ps.length) {
            this.pathRemoved(ps[i]);
            ++i;
        }
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reload() {
        this.statistics = new ArrayList<Long>();
        this.classPath = new ClassPathMonitor(this);
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            this.sourcePaths2.clear();
        }
        this.isStorageResolved = false;
        this.dependsOn.clear();
        this.usedBy.clear();
        this.libraries.clear();
        long begin = System.currentTimeMillis();
        this.classPath.init();
        this.resolve();
        long end = System.currentTimeMillis();
        return end - begin;
    }

    public void store() throws IOException {
        try {
            if (!this.project.hasNature("org.jboss.tools.jst.web.kb.kbnature")) {
                return;
            }
        }
        catch (CoreException coreException) {}
        File file = this.getStorageFile();
        file.getParentFile().mkdirs();
        Element root = XMLUtilities.createDocumentElement((String)"kb-project");
        this.storeProjectDependencies(root);
        this.storeSourcePaths2(root);
        if (this.validationContext != null) {
            this.validationContext.store(root);
        }
        XMLUtilities.serialize((Element)root, (String)file.getAbsolutePath());
    }

    private File getStorageFile() {
        IPath path = WebKbPlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName() + ".xml");
        return file;
    }

    public void clearStorage() {
        File f = this.getStorageFile();
        if (f != null && f.isFile()) {
            f.delete();
        }
    }

    @Override
    public IValidationContext getValidationContext() {
        if (this.validationContext == null) {
            this.validationContext = new ProjectValidationContext();
        }
        return this.validationContext;
    }

    private void loadProjectDependencies(Element root) {
        Element usedElement;
        Element dependsOnElement = XMLUtilities.getUniqueChild((Element)root, (String)"depends-on-projects");
        if (dependsOnElement != null) {
            Element[] paths = XMLUtilities.getChildren((Element)dependsOnElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible()) {
                    KbProject.checkKBBuilderInstalled((IResource)project);
                    KbProject sp = (KbProject)KbProjectFactory.getKbProject(project, false);
                    if (sp != null) {
                        if (sp.isMock) {
                            this.addKbProject(sp);
                        } else {
                            this.dependsOn.add(sp);
                            sp.addDependentKbProject(this);
                        }
                    }
                }
                ++i;
            }
        }
        if ((usedElement = XMLUtilities.getUniqueChild((Element)root, (String)"used-by-projects")) != null) {
            Element[] paths = XMLUtilities.getChildren((Element)usedElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                KbProject sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = (KbProject)KbProjectFactory.getKbProject(project, false)) != null) {
                    this.usedBy.add(sp);
                }
                ++i;
            }
        }
    }

    private void loadSourcePaths2(Element root) {
        block20: {
            Properties context = new Properties();
            context.put("kbProject", this);
            Element sourcePathsElement = XMLUtilities.getUniqueChild((Element)root, (String)"paths");
            if (sourcePathsElement == null) {
                return;
            }
            Element[] paths = XMLUtilities.getChildren((Element)sourcePathsElement, (String)"path");
            if (paths == null) break block20;
            int i = 0;
            while (i < paths.length) {
                block21: {
                    Path path;
                    block22: {
                        String p = paths[i].getAttribute("value");
                        if (p == null || p.trim().length() == 0 || this.sourcePaths2.containsKey(path = new Path(p.trim()))) break block21;
                        if (this.getClassPath().hasPath((IPath)path)) break block22;
                        boolean ok = false;
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                        if (folder != null && folder.exists() && folder.isSynchronized(2)) {
                            ok = true;
                        } else {
                            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            if (f != null && f.exists() && f.isSynchronized(0)) {
                                ok = true;
                            }
                        }
                        if (!ok) break block21;
                    }
                    context.put("path", path);
                    long t1 = System.currentTimeMillis();
                    LoadedDeclarations ds = new LoadedDeclarations();
                    Element libraries = XMLUtilities.getUniqueChild((Element)paths[i], (String)"libraries");
                    if (libraries != null) {
                        Element[] cs;
                        Element[] elementArray = cs = XMLUtilities.getChildren((Element)libraries, (String)"library");
                        int n = cs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Element library = elementArray[n2];
                            String cls = library.getAttribute("class");
                            AbstractTagLib tagLib = null;
                            if ("tld".equals(cls)) {
                                tagLib = new TLDLibrary();
                            } else if ("facelet".equals(cls)) {
                                tagLib = new FaceletTagLibrary();
                            } else if ("faces-config".equals(cls)) {
                                tagLib = new FacesConfigTagLibrary();
                            } else if ("composite".equals(cls)) {
                                tagLib = new CompositeTagLibrary();
                            }
                            if (tagLib != null) {
                                tagLib.loadXML(library, context);
                                ds.getLibraries().add(tagLib);
                            }
                            ++n2;
                        }
                    }
                    this.getClassPath().pathLoaded((IPath)path);
                    this.registerComponents(ds, (IPath)path);
                    long t2 = System.currentTimeMillis();
                    if (this.statistics != null) {
                        this.statistics.add(new Long(t2 - t1));
                        if (t2 - t1 > 30L) {
                            System.out.println("--->" + this.statistics.size() + " " + (t2 - t1));
                            System.out.println("stop");
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSourcePaths2(Element root) {
        Properties context = new Properties();
        Element sourcePathsElement = XMLUtilities.createElement((Element)root, (String)"paths");
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            for (IPath path : this.sourcePaths2.keySet()) {
                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (f != null && f.exists() && f.getProject() != this.project) continue;
                context.put("path", path);
                LoadedDeclarations ds = this.sourcePaths2.get(path);
                Element pathElement = XMLUtilities.createElement((Element)sourcePathsElement, (String)"path");
                pathElement.setAttribute("value", path.toString());
                List<ITagLibrary> fs = ds.getLibraries();
                if (fs == null || fs.isEmpty()) continue;
                Element cse = XMLUtilities.createElement((Element)pathElement, (String)"libraries");
                for (ITagLibrary d : fs) {
                    if (d instanceof ICustomTagLibrary) continue;
                    AbstractTagLib t = (AbstractTagLib)d;
                    t.toXML(cse, context);
                }
            }
        }
    }

    private void storeProjectDependencies(Element root) {
        Element dependsOnElement = XMLUtilities.createElement((Element)root, (String)"depends-on-projects");
        for (IKbProject iKbProject : this.dependsOn) {
            if (!iKbProject.getProject().isAccessible()) continue;
            Element pathElement = XMLUtilities.createElement((Element)dependsOnElement, (String)"project");
            pathElement.setAttribute("name", iKbProject.getProject().getName());
        }
        Element element = XMLUtilities.createElement((Element)root, (String)"used-by-projects");
        for (IKbProject iKbProject : this.usedBy) {
            if (!iKbProject.getProject().isAccessible()) continue;
            Element pathElement = XMLUtilities.createElement((Element)element, (String)"project");
            pathElement.setAttribute("name", iKbProject.getProject().getName());
        }
    }

    Map<IPath, LoadedDeclarations> getAllDeclarations() throws CloneNotSupportedException {
        HashMap<IPath, LoadedDeclarations> map = new HashMap<IPath, LoadedDeclarations>();
        ITagLibrary[] iTagLibraryArray = this.getTagLibraries();
        int n = iTagLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITagLibrary f = iTagLibraryArray[n2];
            IPath p = f.getSourcePath();
            if (p != null && !EclipseResourceUtil.isJar((String)p.toString())) {
                LoadedDeclarations ds = (LoadedDeclarations)map.get(p);
                if (ds == null) {
                    ds = new LoadedDeclarations();
                    map.put(p, ds);
                }
                ds.getLibraries().add(f.clone());
            }
            ++n2;
        }
        return map;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length && command == null) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            Object handle;
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderID) || builderName.equals(EXTERNAL_TOOL_BUILDER) && (handle = commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE)) != null && handle.toString().indexOf(builderID) >= 0) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponents(LoadedDeclarations ds, IPath source) {
        ITagLibrary[] libraries = ds.getLibraries().toArray(new ITagLibrary[0]);
        if (libraries.length == 0) {
            this.pathRemoved(source);
            if (EclipseResourceUtil.isJar((String)source.toString())) {
                Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
                synchronized (map) {
                    this.sourcePaths2.put(source, ds);
                }
            }
            return;
        }
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            this.sourcePaths2.put(source, ds);
        }
        Map<Object, ITagLibrary> currentLibraries = this.findLibraryDeclarations(source);
        List addedLibraries = null;
        ITagLibrary[] iTagLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            ITagLibrary library = iTagLibraryArray[n2];
            AbstractTagLib loaded = (AbstractTagLib)library;
            AbstractTagLib current = (AbstractTagLib)currentLibraries.remove(loaded.getId());
            loaded.setSourcePath(source);
            if (current != null && current.getClass() != loaded.getClass()) {
                this.libraries.removeLibrary(current);
                current = null;
            }
            if (current != null) {
                boolean uriChanged;
                boolean bl = uriChanged = !this.stringsEqual(current.getURI(), loaded.getURI());
                if (uriChanged) {
                    this.libraries.removeLibrary(current);
                }
                List<Change> changes = current.merge(loaded);
                if (uriChanged) {
                    this.libraries.addLibrary(current);
                }
                this.fireChanges(changes);
            } else {
                if (((KbObject)((Object)library)).getParent() == null) {
                    this.adopt((KbObject)((Object)library));
                }
                this.libraries.addLibrary(library);
                addedLibraries = Change.addChange(addedLibraries, (Change)new Change((Object)this, null, null, (Object)loaded));
            }
            ++n2;
        }
        this.fireChanges(addedLibraries);
        this.libraryDeclarationsRemoved(currentLibraries);
        try {
            this.registerComponentsInDependentProjects(ds, source);
        }
        catch (CloneNotSupportedException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void registerComponentsInDependentProjects(LoadedDeclarations ds, IPath source) throws CloneNotSupportedException {
        if (this.usedBy.isEmpty()) {
            return;
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        for (KbProject p : this.usedBy) {
            p.resolve();
            LoadedDeclarations ds1 = new LoadedDeclarations();
            for (ITagLibrary f : ds.getLibraries()) {
                ds1.getLibraries().add(f.clone());
            }
            p.registerComponents(ds1, source);
        }
    }

    public boolean isPathLoaded(IPath source) {
        return this.sourcePaths2.containsKey(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathRemoved(IPath source) {
        if (!this.sourcePaths2.containsKey(source)) {
            return;
        }
        Map<IPath, LoadedDeclarations> map = this.sourcePaths2;
        synchronized (map) {
            this.sourcePaths2.remove(source);
        }
        List changes = null;
        Set<ITagLibrary> ls = this.libraries.removePath(source);
        if (ls != null) {
            for (ITagLibrary l : ls) {
                changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)l, null));
            }
        }
        this.fireChanges(changes);
        this.firePathRemovedToDependentProjects(source);
    }

    public void firePathRemovedToDependentProjects(IPath source) {
        if (this.usedBy.isEmpty()) {
            return;
        }
        if (EclipseResourceUtil.isJar((String)source.toString())) {
            return;
        }
        for (KbProject p : this.usedBy) {
            p.resolve();
            p.pathRemoved(source);
        }
    }

    public Map<Object, ITagLibrary> findLibraryDeclarations(IPath source) {
        HashMap<Object, ITagLibrary> map = new HashMap<Object, ITagLibrary>();
        Set<ITagLibrary> fs = this.libraries.getLibrariesBySource(source);
        if (fs != null) {
            for (ITagLibrary c : fs) {
                KbObject ci = (KbObject)((Object)c);
                map.put(ci.getId(), c);
            }
        }
        return map;
    }

    void libraryDeclarationsRemoved(Map<Object, ITagLibrary> removed) {
        if (removed == null || removed.isEmpty()) {
            return;
        }
        Iterator<ITagLibrary> iterator = removed.values().iterator();
        List changes = null;
        while (iterator.hasNext()) {
            ITagLibrary c = iterator.next();
            this.libraries.removeLibrary(c);
            changes = Change.addChange(changes, (Change)new Change((Object)this, null, (Object)c, null));
        }
        this.fireChanges(changes);
    }

    public void postponeFiring() {
        if (this.postponedChanges == null) {
            this.postponedChanges = new ArrayList<Change>();
        }
    }

    public void fireChanges() {
        if (this.postponedChanges == null) {
            return;
        }
        List<Change> changes = this.postponedChanges;
        this.postponedChanges = null;
        this.fireChanges(changes);
    }

    void fireChanges(List<Change> changes) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        if (this.postponedChanges != null) {
            this.postponedChanges.addAll(changes);
            return;
        }
    }

    public static boolean checkKBBuilderInstalled(IResource resource) {
        IMarker[] markers;
        IProject project;
        IProject iProject = project = resource == null || !resource.isAccessible() ? null : resource.getProject();
        if (project == null) {
            return false;
        }
        boolean kbNatureFound = false;
        boolean kbBuilderFound = false;
        try {
            kbNatureFound = project.getNature("org.jboss.tools.jst.web.kb.kbnature") != null;
            IProjectDescription description = project.getDescription();
            Object command = null;
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length && command == null) {
                if (commands[i].getBuilderName().equals(KbBuilder.BUILDER_ID)) {
                    kbBuilderFound = true;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            WebKbPlugin.getDefault().logError(ex);
        }
        if (kbNatureFound && kbBuilderFound) {
            markers = KbProject.getOwnedMarkers((IResource)project);
            if (markers != null && markers.length > 0) {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int command = 0;
                while (command < n) {
                    try {
                        project.deleteMarkers(KB_PROBLEM_MARKER_TYPE, true, 1);
                        project.setPersistentProperty(KbProjectFactory.NATURE_MOCK, null);
                    }
                    catch (CoreException ex) {
                        WebKbPlugin.getDefault().logError(ex);
                    }
                    ++command;
                }
            }
            return true;
        }
        markers = KbProject.getOwnedMarkers((IResource)project);
        if (markers == null || markers.length == 0) {
            try {
                KbProject.createOrUpdateKbProblemMarker(null, (IResource)project, !kbNatureFound, !kbBuilderFound);
            }
            catch (CoreException ex) {
                WebKbPlugin.getDefault().logError(ex);
            }
        } else {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                try {
                    m = KbProject.createOrUpdateKbProblemMarker(m, (IResource)project, !kbNatureFound, !kbBuilderFound);
                }
                catch (CoreException ex) {
                    WebKbPlugin.getDefault().logError(ex);
                }
                ++n2;
            }
        }
        return false;
    }

    private static IMarker[] getOwnedMarkers(IResource r) {
        ArrayList<IMarker> l = null;
        try {
            IMarker[] ms;
            if (r != null && r.isAccessible() && (ms = r.findMarkers(null, false, 1)) != null) {
                int i = 0;
                while (i < ms.length) {
                    String _type;
                    if (ms[i] != null && (_type = ms[i].getType()) != null && _type.equals(KB_PROBLEM_MARKER_TYPE) && ms[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        if (l == null) {
                            l = new ArrayList<IMarker>();
                        }
                        l.add(ms[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return l == null ? null : l.toArray(new IMarker[0]);
    }

    private static IMarker createOrUpdateKbProblemMarker(IMarker m, IResource r, boolean kbNatureIsAbsent, boolean kbBuilderIsAbsent) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(kbNatureIsAbsent ? KbMessages.KBNATURE_NOT_FOUND : "");
        args.add(kbBuilderIsAbsent ? KbMessages.KBBUILDER_NOT_FOUND : "");
        String message = MessageFormat.format(KbMessages.KBPROBLEM, args.toArray());
        if (m == null) {
            m = r.createMarker(KB_PROBLEM_MARKER_TYPE);
            r.setPersistentProperty(KbProjectFactory.NATURE_MOCK, "true");
            KbProjectFactory.getKbProject(r.getProject(), true);
        }
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", 1);
        m.setAttribute("priority", 1);
        return m;
    }
}

