/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.JSF2ResourcesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

public class KbResourceVisitor
implements IResourceVisitor {
    static IFileScanner[] FILE_SCANNERS = new IFileScanner[]{new XMLScanner()};
    JSF2ResourcesScanner jsf2scanner = new JSF2ResourcesScanner();
    KbProject p;
    IPath[] outs = new IPath[0];
    IPath[] srcs = new IPath[0];
    IPath webinf = null;
    IPath jsf2resources = null;
    IResource jsf2resourcesFolder = null;
    boolean jsf2resourcesProcessed = false;

    public KbResourceVisitor(KbProject p) {
        this.p = p;
        if (p.getProject() != null && p.getProject().isOpen()) {
            IResource wir;
            XModelObject wio;
            this.getJavaSourceRoots(p.getProject());
            XModel model = InnerModelHelper.createXModel((IProject)p.getProject());
            if (model != null && (wio = FileSystemsHelper.getWebInf((XModel)model)) != null && (wir = (IResource)wio.getAdapter(IResource.class)) != null) {
                this.webinf = wir.getFullPath();
                this.jsf2resources = this.webinf.removeLastSegments(1).append("resources");
                IFolder rf = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.jsf2resources);
                if (rf == null || !rf.exists()) {
                    this.jsf2resources = null;
                } else {
                    this.jsf2resourcesFolder = rf;
                }
            }
        }
    }

    public IResourceVisitor getVisitor() {
        return this;
    }

    public void init() {
        this.jsf2resourcesProcessed = false;
    }

    public boolean visit(IResource resource) {
        int i;
        if (resource instanceof IFile) {
            IFile f = (IFile)resource;
            i = 0;
            while (i < this.outs.length) {
                if (this.outs[i].isPrefixOf(resource.getFullPath())) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < FILE_SCANNERS.length) {
                IFileScanner scanner = FILE_SCANNERS[i];
                if (scanner.isRelevant(f)) {
                    long t = System.currentTimeMillis();
                    if (!scanner.isLikelyComponentSource(f)) {
                        this.p.pathRemoved(f.getFullPath());
                        return false;
                    }
                    LoadedDeclarations c = null;
                    try {
                        c = scanner.parse(f, this.p);
                    }
                    catch (ScannerException e) {
                        WebKbPlugin.getDefault().logError(e);
                    }
                    if (c != null) {
                        this.componentsLoaded(c, (IResource)f);
                    }
                    System.currentTimeMillis();
                }
                ++i;
            }
            if (this.jsf2resources != null && this.jsf2resources.isPrefixOf(f.getFullPath()) && this.jsf2scanner.isLikelyComponentSource(f)) {
                this.processJSF2Resources();
            }
        }
        if (resource instanceof IFolder) {
            IPath path = resource.getFullPath();
            i = 0;
            while (i < this.outs.length) {
                if (this.outs[i].isPrefixOf(path)) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.srcs.length) {
                if (this.srcs[i].isPrefixOf(path) || path.isPrefixOf(this.srcs[i])) {
                    return true;
                }
                ++i;
            }
            if (this.jsf2resources != null) {
                if (this.jsf2resources.isPrefixOf(path)) {
                    this.processJSF2Resources();
                    return false;
                }
                if (path.isPrefixOf(this.jsf2resources)) {
                    return true;
                }
            }
            if (this.webinf != null && (this.webinf.isPrefixOf(path) || path.isPrefixOf(this.webinf) || this.webinf.removeLastSegments(1).isPrefixOf(path))) {
                return true;
            }
            return resource == resource.getProject();
        }
        return true;
    }

    void processJSF2Resources() {
        if (this.jsf2resourcesFolder == null || this.jsf2resourcesProcessed) {
            return;
        }
        this.jsf2resourcesProcessed = true;
        JSF2ResourcesScanner scanner = new JSF2ResourcesScanner();
        LoadedDeclarations c = null;
        try {
            c = scanner.parse((IFolder)this.jsf2resourcesFolder, (IKbProject)this.p);
        }
        catch (ScannerException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        if (c != null) {
            this.componentsLoaded(c, this.jsf2resourcesFolder);
        }
    }

    void componentsLoaded(LoadedDeclarations c, IResource resource) {
        if (c == null || c.getLibraries().size() == 0) {
            return;
        }
        this.p.registerComponents(c, resource.getFullPath());
    }

    void getJavaSourceRoots(IProject project) {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return;
        }
        ArrayList<IPath> ps = new ArrayList<IPath>();
        ArrayList<IPath> os = new ArrayList<IPath>();
        try {
            IPath output = javaProject.getOutputLocation();
            if (output != null) {
                os.add(output);
            }
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                if (es[i].getEntryKind() == 3) {
                    IPath out;
                    IResource findMember = ModelPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                    if (findMember != null && findMember.exists()) {
                        ps.add(findMember.getFullPath());
                    }
                    if ((out = es[i].getOutputLocation()) != null && !os.contains(out)) {
                        os.add(out);
                    }
                }
                ++i;
            }
            this.srcs = ps.toArray(new IPath[0]);
            this.outs = os.toArray(new IPath[0]);
        }
        catch (CoreException ce) {
            ModelPlugin.getPluginLog().logError("Error while locating java source roots for " + project, (Throwable)ce);
        }
    }
}

