/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.jst.web.kb.IXmlContext;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlContextImpl
extends ELContextImpl
implements IXmlContext {
    protected IDocument document;
    protected Map<IRegion, Map<String, INameSpace>> nameSpaces = new HashMap<IRegion, Map<String, INameSpace>>();

    public void setResource(IFile resource) {
        super.setResource(resource);
        FileEditorInput editorInput = null;
        try {
            editorInput = new FileEditorInput(resource);
            this.document = this.getConnectedDocument((IEditorInput)editorInput);
        }
        finally {
            this.releaseConnectedDocument((IEditorInput)editorInput);
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public Map<String, List<INameSpace>> getNameSpaces(int offset) {
        HashMap<String, List<INameSpace>> result = new HashMap<String, List<INameSpace>>();
        HashMap<INameSpace, IRegion> namespaceToRegions = new HashMap<INameSpace, IRegion>();
        for (IRegion region : this.nameSpaces.keySet()) {
            Map<String, INameSpace> namespaces;
            if (offset < region.getOffset() || offset > region.getOffset() + region.getLength() || (namespaces = this.nameSpaces.get(region)) == null) continue;
            for (INameSpace ns : namespaces.values()) {
                INameSpace existingNameSpace = this.findNameSpaceByPrefix(namespaceToRegions.keySet(), ns.getPrefix());
                IRegion existingRegion = (IRegion)namespaceToRegions.get(existingNameSpace);
                if (existingRegion != null) {
                    if (region.getOffset() <= existingRegion.getOffset()) continue;
                    namespaceToRegions.remove(existingNameSpace);
                    namespaceToRegions.put(ns, region);
                    continue;
                }
                namespaceToRegions.put(ns, region);
            }
        }
        for (INameSpace ns : namespaceToRegions.keySet()) {
            ArrayList<INameSpace> list = (ArrayList<INameSpace>)result.get(ns.getURI());
            if (list == null) {
                list = new ArrayList<INameSpace>();
            }
            list.add(ns);
            result.put(ns.getURI(), list);
        }
        return result;
    }

    public INameSpace findNameSpaceByPrefix(Set<INameSpace> namespaces, String prefix) {
        if (namespaces != null && prefix != null) {
            for (INameSpace ns : namespaces) {
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        return null;
    }

    public void addNameSpace(IRegion region, INameSpace nameSpace) {
        if (this.nameSpaces.get(region) == null) {
            HashMap nameSpaceMap = new HashMap();
            this.nameSpaces.put(region, nameSpaceMap);
        }
        this.nameSpaces.get(region).put(nameSpace.getPrefix(), nameSpace);
    }

    private IDocument getConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return provider.getDocument((Object)input);
    }

    private void releaseConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        provider.disconnect((Object)input);
    }
}

