/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.proposal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.proposal.ModelProposalType;

public class ResourcePathProposalType
extends ModelProposalType {
    private static final String IMAGE_NAME = "ResourcePathProposal.gif";
    private static Image ICON;
    private static Set<String> GRAPHIC_FILE_EXTENSIONS;
    private static Set<String> PAGE_FILE_EXTENSIONS;
    private static String PATH_ADDITION;
    private IContainer webRootResource;
    private Set<String> extensions;
    private List<String> enumeration;
    private static final String EXTENSIONS_PARAM_NAME = "extensions";
    private static final String IMAGE_PARAM_TYPE = "%image%";
    private static final String PAGE_PARAM_TYPE = "%page%";

    static {
        GRAPHIC_FILE_EXTENSIONS = new HashSet<String>();
        PAGE_FILE_EXTENSIONS = new HashSet<String>();
        String[] images = new String[]{"gif", "jpeg", "jpg", "png", "wbmp", "bmp"};
        int i = 0;
        while (i < images.length) {
            GRAPHIC_FILE_EXTENSIONS.add(images[i]);
            ++i;
        }
        String[] pages = new String[]{"jsp", "htm", "html", "xhtml", "xml"};
        int i2 = 0;
        while (i2 < pages.length) {
            PAGE_FILE_EXTENSIONS.add(pages[i2]);
            ++i2;
        }
        PATH_ADDITION = "pathAddition";
    }

    protected void init(IPageContext context) {
        super.init(context);
        this.webRootResource = null;
        if (this.xModel != null) {
            XModelObject webInf = FileSystemsHelper.getWebInf((XModel)this.xModel);
            XModelObject webRoot = FileSystemsHelper.getWebRoot((XModel)this.xModel);
            if (webInf != null && webRoot != null) {
                this.webRootResource = (IContainer)EclipseResourceUtil.getResource((XModelObject)webRoot);
            }
        }
        if (this.extensions == null) {
            this.initExtensions();
        }
        if (this.enumeration == null) {
            this.enumeration = new ArrayList<String>();
            if (this.params != null) {
                int i = 0;
                while (i < this.params.length) {
                    if (PATH_ADDITION.equals(this.params[i].getName())) {
                        this.enumeration.add(this.params[i].getValue());
                    }
                    ++i;
                }
            }
        }
    }

    public TextProposal[] getProposals(KbQuery query) {
        if (!this.isReadyToUse()) {
            return EMPTY_PROPOSAL_LIST;
        }
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        ImagePathDescriptor[] images = this.getImagesFilesPathes(query.getValue());
        int i = 0;
        while (i < images.length) {
            TextProposal proposal = new TextProposal();
            proposal.setLabel(images[i].getQueryPath());
            String replacementString = images[i].getQueryPath();
            if (images[i].getResource() instanceof IFolder) {
                replacementString = String.valueOf(replacementString) + "/";
                proposal.setAutoActivationContentAssistantAfterApplication(true);
            }
            proposal.setReplacementString(replacementString);
            proposal.setPosition(replacementString.length());
            if (ICON == null) {
                ICON = ImageDescriptor.createFromFile(WebKbPlugin.class, (String)IMAGE_NAME).createImage();
            }
            proposal.setImage(ICON);
            proposals.add(proposal);
            ++i;
        }
        for (String path : this.enumeration) {
            TextProposal proposal = new TextProposal();
            proposal.setLabel(path);
            String replacementString = path;
            proposal.setAutoActivationContentAssistantAfterApplication(false);
            proposal.setReplacementString(replacementString);
            proposal.setPosition(replacementString.length());
            if (ICON == null) {
                ICON = ImageDescriptor.createFromFile(WebKbPlugin.class, (String)IMAGE_NAME).createImage();
            }
            proposal.setImage(ICON);
            proposals.add(proposal);
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private void initExtensions() {
        String value = this.getParamValue(EXTENSIONS_PARAM_NAME);
        if (value != null && !value.equals("*")) {
            if (IMAGE_PARAM_TYPE.equals(value)) {
                this.extensions = GRAPHIC_FILE_EXTENSIONS;
            } else if (PAGE_PARAM_TYPE.equals(value)) {
                this.extensions = PAGE_FILE_EXTENSIONS;
            } else {
                StringTokenizer st = new StringTokenizer(value, ",;");
                if (st.countTokens() > 0) {
                    this.extensions = new HashSet<String>();
                    while (st.hasMoreTokens()) {
                        String t = st.nextToken().trim();
                        if (t.length() == 0) continue;
                        if (IMAGE_PARAM_TYPE.equals(t)) {
                            this.extensions.addAll(GRAPHIC_FILE_EXTENSIONS);
                            continue;
                        }
                        if (PAGE_PARAM_TYPE.equals(t)) {
                            this.extensions.addAll(PAGE_FILE_EXTENSIONS);
                            continue;
                        }
                        this.extensions.add(t);
                    }
                }
            }
        }
    }

    protected boolean isReadyToUse() {
        return this.webRootResource != null;
    }

    private ImagePathDescriptor[] getImagesFilesPathes(String query) {
        if ((query = query.trim()).indexOf(92) > -1) {
            return new ImagePathDescriptor[0];
        }
        if (query.length() == 0) {
            query = "/";
        }
        int lastSeparator = query.lastIndexOf(47);
        String name = null;
        String pathWithoutLastSegment = null;
        if (lastSeparator > -1) {
            pathWithoutLastSegment = query.substring(0, lastSeparator);
            name = lastSeparator + 1 < query.length() ? query.substring(lastSeparator + 1, query.length()) : "";
        } else {
            pathWithoutLastSegment = "";
            name = query;
        }
        if (name.equals(".") || name.equals("..")) {
            pathWithoutLastSegment = pathWithoutLastSegment.length() > 0 ? String.valueOf(pathWithoutLastSegment) + "/" + name : (query.startsWith("/") ? "/" + name : name);
            name = "";
        }
        if (name == null) {
            name = "";
        }
        String startPath = pathWithoutLastSegment;
        if (pathWithoutLastSegment.startsWith("/")) {
            startPath = pathWithoutLastSegment.length() > 1 ? pathWithoutLastSegment.substring(1) : "";
        }
        IResource resource = query.startsWith("/") ? this.webRootResource.findMember(startPath) : this.context.getResource().getParent().findMember(startPath);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            if (resource != null) {
                resource.accept((IResourceVisitor)new ImagesFinder(resources, name, this.extensions));
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        ImagePathDescriptor[] filesPathes = new ImagePathDescriptor[resources.size()];
        int i = 0;
        while (i < filesPathes.length) {
            String prefix = pathWithoutLastSegment.toString();
            if (!prefix.endsWith("/")) {
                prefix = String.valueOf(prefix) + '/';
            }
            IResource r = (IResource)resources.get(i);
            filesPathes[i] = new ImagePathDescriptor(String.valueOf(prefix) + r.getName(), r);
            ++i;
        }
        return filesPathes;
    }

    private static class ImagePathDescriptor {
        private String queryPath;
        private IResource resource;

        public ImagePathDescriptor(String queryPath, IResource resource) {
            this.queryPath = queryPath;
            this.resource = resource;
        }

        public String getQueryPath() {
            return this.queryPath;
        }

        public IResource getResource() {
            return this.resource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImagesFinder
    implements IResourceVisitor {
        private List<IResource> resources;
        private int count = 0;
        private String name;
        Set<String> extensions = null;

        public ImagesFinder(List<IResource> resources, String name, Set<String> extensions) {
            this.resources = resources;
            this.name = name;
            this.extensions = extensions;
        }

        boolean acceptExtension(String ext) {
            if (ext != null) {
                ext = ext.toLowerCase();
            }
            return this.extensions == null || this.extensions.contains(ext);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (resource.getName().startsWith(this.name) && this.acceptExtension(file.getFileExtension())) {
                    this.resources.add(resource);
                }
            } else if (resource instanceof IFolder) {
                if (this.count == 0) {
                    ++this.count;
                    return true;
                }
                if (resource.getName().startsWith(this.name) && !resource.getName().equals("WEB-INF") && !resource.getName().equals("META-INF")) {
                    this.resources.add(resource);
                }
            }
            return false;
        }
    }
}

