/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.AbstractClassPathMonitor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathMonitor
extends AbstractClassPathMonitor<KbProject> {
    public ClassPathMonitor(KbProject project) {
        this.project = project;
    }

    public void init() {
        this.model = InnerModelHelper.createXModel((IProject)((KbProject)this.project).getProject());
    }

    public IProject getProjectResource() {
        return ((KbProject)this.project).getProject();
    }

    public void process() {
        Iterator it = this.processedPaths.iterator();
        while (it.hasNext()) {
            String p = (String)it.next();
            if (this.paths.contains(p)) continue;
            ((KbProject)this.project).pathRemoved((IPath)new Path(p));
            it.remove();
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = (String)this.paths.get(i);
            if (!this.processedPaths.contains(p)) {
                this.processedPaths.add(p);
                LibraryScanner scanner = new LibraryScanner();
                String fileName = new File(p).getName();
                if (!EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName)) {
                    String jsname = "lib-" + fileName;
                    XModelObject o = this.model.getByPath("FileSystems").getChildByPath(jsname);
                    if (o != null) {
                        LoadedDeclarations c = null;
                        try {
                            if (scanner.isLikelyComponentSource(o)) {
                                c = scanner.parse(o, (IPath)new Path(p), (IKbProject)this.project);
                            }
                        }
                        catch (ScannerException e) {
                            WebModelPlugin.getDefault().logError((Throwable)e);
                        }
                        if (c == null) {
                            c = new LoadedDeclarations();
                        }
                        if (c != null) {
                            this.componentsLoaded(c, (IPath)new Path(p));
                        }
                    }
                }
            }
            ++i;
        }
        this.validateProjectDependencies();
    }

    public void validateProjectDependencies() {
        List<KbProject> ps = null;
        try {
            ps = this.getKbProjects(((KbProject)this.project).getProject());
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set<KbProject> set = ((KbProject)this.project).getKbProjects();
            HashSet<KbProject> removable = new HashSet<KbProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (KbProject p : ps) {
                ((KbProject)this.project).addKbProject(p);
            }
            for (KbProject p : removable) {
                ((KbProject)this.project).removeKbProject(p);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<KbProject> ps = null;
        try {
            ps = this.getKbProjects(((KbProject)this.project).getProject());
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set<KbProject> set = ((KbProject)this.project).getKbProjects();
            HashSet<KbProject> removable = new HashSet<KbProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            Iterator<KbProject> iterator = ps.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
            iterator = removable.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
        }
        return false;
    }

    void componentsLoaded(LoadedDeclarations c, IPath path) {
        if (c == null) {
            return;
        }
        ((KbProject)this.project).registerComponents(c, path);
    }

    List<KbProject> getKbProjects(IProject project) throws CoreException {
        ArrayList<KbProject> list = new ArrayList<KbProject>();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible()) {
                    KbProject.checkKBBuilderInstalled((IResource)p);
                    IKbProject sp = KbProjectFactory.getKbProject(p, false);
                    if (sp != null) {
                        list.add((KbProject)sp);
                    }
                }
                ++i;
            }
        }
        return list;
    }
}

