/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.List;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITLDLibrary;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDLibrary
extends AbstractTagLib
implements ITLDLibrary {
    public static final String DISPLAY_NAME = "display-name";
    public static final String SHORT_NAME = "short-name";
    public static final String VERSION = "version";
    String displayName = null;
    String shortName = null;
    String version = null;

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setDisplayName(IValueInfo s) {
        this.displayName = s == null ? null : s.getValue();
        this.attributesInfo.put(DISPLAY_NAME, s);
    }

    public void setShortName(IValueInfo s) {
        this.shortName = s == null ? null : s.getValue();
        this.attributesInfo.put(SHORT_NAME, s);
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersion(IValueInfo s) {
        this.version = s == null ? null : s.getValue();
        this.attributesInfo.put(VERSION, s);
    }

    public void createDefaultNameSpace() {
        this.setDefaultNameSpace(new INameSpace(){

            public String getURI() {
                return TLDLibrary.this.uri;
            }

            public String getPrefix() {
                return TLDLibrary.this.shortName;
            }
        });
    }

    @Override
    public TLDLibrary clone() throws CloneNotSupportedException {
        return (TLDLibrary)super.clone();
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        TLDLibrary l = (TLDLibrary)s;
        if (!this.stringsEqual(this.displayName, l.displayName)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, DISPLAY_NAME, (Object)this.displayName, (Object)l.displayName));
            this.displayName = l.displayName;
        }
        if (!this.stringsEqual(this.shortName, l.shortName)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, SHORT_NAME, (Object)this.shortName, (Object)l.shortName));
            this.shortName = l.shortName;
        }
        if (!this.stringsEqual(this.version, l.version)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, VERSION, (Object)this.version, (Object)l.version));
            this.version = l.version;
        }
        return changes;
    }

    @Override
    public String getXMLClass() {
        return "tld";
    }

    @Override
    protected void saveAttributeValues(Element element) {
        super.saveAttributeValues(element);
        if (this.attributesInfo.get(VERSION) == null && this.version != null) {
            element.setAttribute(VERSION, this.version);
        }
    }

    @Override
    protected void loadAttributeValues(Element element) {
        super.loadAttributeValues(element);
        this.setShortName((IValueInfo)this.attributesInfo.get(SHORT_NAME));
        this.setDisplayName((IValueInfo)this.attributesInfo.get(DISPLAY_NAME));
        this.setVersion((IValueInfo)this.attributesInfo.get(VERSION));
        if (this.version == null && element.hasAttribute(VERSION)) {
            this.version = element.getAttribute(VERSION);
        }
    }
}

