/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.validation.IValidatingProjectSet;
import org.jboss.tools.jst.web.kb.validation.IValidationContext;
import org.jboss.tools.jst.web.kb.validation.IValidator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext
implements IValidationContext {
    private IValidationContext rootContext;
    private IProject rootProject;
    private static List<IValidator> ALL_VALIDATORS;
    private List<IValidator> validators = new ArrayList<IValidator>();

    public ValidationContext(IProject project) {
        if (ALL_VALIDATORS == null) {
            ALL_VALIDATORS = new ArrayList<IValidator>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.jst.web.kb.validator");
            if (extensionPoint != null) {
                HashMap<String, IValidator> extendsIds = new HashMap<String, IValidator>();
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        try {
                            IValidator validator = (IValidator)elements[j].createExecutableExtension("class");
                            String extendsId = elements[j].getAttribute("extends");
                            if (extendsId != null) {
                                IValidator[] tempArray;
                                IValidator[] iValidatorArray = tempArray = ALL_VALIDATORS.toArray(new IValidator[0]);
                                int n = tempArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IValidator vld = iValidatorArray[n2];
                                    if (extendsId.equals(vld.getId())) {
                                        ALL_VALIDATORS.remove(vld);
                                    }
                                    ++n2;
                                }
                                extendsIds.put(extendsId, validator);
                            }
                            if (!extendsIds.containsKey(validator.getId())) {
                                ALL_VALIDATORS.add(validator);
                            }
                        }
                        catch (CoreException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        for (IValidator validator : ALL_VALIDATORS) {
            if (!validator.shouldValidate(project)) continue;
            this.validators.add(validator);
        }
        for (IValidator validator : this.validators) {
            IValidatingProjectSet prSet = validator.getValidatingProjects(project);
            IProject vProject = prSet.getRootProject();
            if (vProject != project) {
                this.rootProject = vProject;
                this.rootContext = prSet.getRootContext();
                continue;
            }
            if (this.rootContext != null) continue;
            this.rootContext = prSet.getRootContext();
        }
        if (this.rootProject == null) {
            this.rootProject = project;
        }
    }

    @Override
    public List<IValidator> getValidators() {
        return this.validators;
    }

    @Override
    public void addLinkedCoreResource(String variableName, IPath linkedResourcePath, boolean declaration) {
        this.rootContext.addLinkedCoreResource(variableName, linkedResourcePath, declaration);
    }

    @Override
    public void addLinkedEl(String variableName, ELReference el) {
        this.rootContext.addLinkedEl(variableName, el);
    }

    @Override
    public void addRemovedFile(IFile file) {
        if (this.rootContext != null) {
            this.rootContext.addRemovedFile(file);
        }
    }

    @Override
    public void addUnnamedCoreResource(IPath fullPath) {
        this.rootContext.addUnnamedCoreResource(fullPath);
    }

    @Override
    public void addUnnamedElResource(IPath fullPath) {
        this.rootContext.addUnnamedElResource(fullPath);
    }

    @Override
    public void addVariableNameForELValidation(String name) {
        this.rootContext.addVariableNameForELValidation(name);
    }

    @Override
    public void clearAll() {
        this.rootContext.clearAll();
    }

    @Override
    public void clearAllResourceLinks() {
        this.rootContext.clearAllResourceLinks();
    }

    @Override
    public void clearElResourceLinks() {
        this.rootContext.clearElResourceLinks();
    }

    @Override
    public void clearOldVariableNameForElValidation() {
        this.rootContext.clearOldVariableNameForElValidation();
    }

    @Override
    public void clearRegisteredFiles() {
        if (this.rootContext != null) {
            this.rootContext.clearRegisteredFiles();
        }
    }

    @Override
    public Set<IPath> getCoreResourcesByVariableName(String variableName, boolean declaration) {
        return this.rootContext.getCoreResourcesByVariableName(variableName, declaration);
    }

    @Override
    public Set<ELReference> getElsByVariableName(String variableName) {
        return this.rootContext.getElsByVariableName(variableName);
    }

    @Override
    public Set<ELReference> getElsForValidation(Set<IFile> changedFiles, boolean onlyChangedVariables) {
        return this.rootContext.getElsForValidation(changedFiles, onlyChangedVariables);
    }

    @Override
    public Set<IFile> getRegisteredFiles() {
        if (this.rootContext == null) {
            return Collections.emptySet();
        }
        return this.rootContext.getRegisteredFiles();
    }

    @Override
    public Set<IFile> getRemovedFiles() {
        if (this.rootContext == null) {
            return Collections.emptySet();
        }
        return this.rootContext.getRemovedFiles();
    }

    @Override
    public Set<IPath> getUnnamedCoreResources() {
        return this.rootContext.getUnnamedCoreResources();
    }

    @Override
    public Set<IPath> getUnnamedElResources() {
        return this.rootContext.getUnnamedElResources();
    }

    @Override
    public Set<String> getVariableNamesByCoreResource(IPath fullPath, boolean declaration) {
        return this.rootContext.getVariableNamesByCoreResource(fullPath, declaration);
    }

    @Override
    public void load(Element root) {
        this.rootContext.load(root);
    }

    @Override
    public void registerFile(IFile file) {
        if (this.rootContext != null) {
            this.rootContext.registerFile(file);
        }
    }

    @Override
    public void removeLinkedCoreResource(IPath resource) {
        this.rootContext.removeLinkedCoreResource(resource);
    }

    @Override
    public void removeLinkedCoreResource(String name, IPath linkedResourcePath) {
        this.rootContext.removeLinkedCoreResource(name, linkedResourcePath);
    }

    @Override
    public void removeLinkedCoreResources(Set<IPath> resources) {
        this.rootContext.removeLinkedCoreResources(resources);
    }

    @Override
    public void removeLinkedEl(String name, ELReference el) {
        this.rootContext.removeLinkedEl(name, el);
    }

    @Override
    public void removeLinkedEls(Set<IFile> resorces) {
        this.rootContext.removeLinkedEls(resorces);
    }

    @Override
    public void removeUnnamedCoreResource(IPath fullPath) {
        this.rootContext.removeUnnamedCoreResource(fullPath);
    }

    @Override
    public void removeUnnamedElResource(IPath fullPath) {
        this.rootContext.removeUnnamedElResource(fullPath);
    }

    @Override
    public void store(Element root) {
        this.rootContext.store(root);
    }

    @Override
    public IProject getRootProject() {
        return this.rootProject;
    }
}

