/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.XModelBasedHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.hyperlink.JSPBundleHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleHyperlink
extends XModelBasedHyperlink {
    private static final String VIEW_TAGNAME = "view";
    private static final String LOCALE_ATTRNAME = "locale";
    private static final String PREFIX_SEPARATOR = ":";
    IRegion fLastRegion = null;

    private String getBundleProperty(IRegion region) {
        boolean useBracket;
        boolean useDot;
        int bracketIndex;
        int dotIndex;
        String fullText;
        block11: {
            if (this.getDocument() == null) {
                return null;
            }
            try {
                fullText = this.getDocument().get(region.getOffset(), region.getLength());
                dotIndex = fullText.indexOf(".");
                bracketIndex = fullText.indexOf("[");
                useDot = false;
                useBracket = false;
                if (dotIndex != -1) {
                    useDot = true;
                }
                if (bracketIndex != -1) {
                    if (!useDot || useDot && dotIndex > bracketIndex) {
                        useBracket = true;
                    }
                    useDot = false;
                }
                if (useDot && fullText.indexOf(".", dotIndex + 1) != -1) {
                    useDot = false;
                }
                if (useDot || useBracket) break block11;
                return null;
            }
            catch (BadLocationException x) {
                JSFExtensionsPlugin.log("", (Exception)((Object)x));
                return null;
            }
        }
        String sProp = null;
        if (useDot) {
            sProp = fullText.substring(dotIndex + 1);
        }
        if (useBracket) {
            int startProp = bracketIndex + 1;
            int endProp = fullText.indexOf("]");
            if (endProp == -1) {
                endProp = fullText.length() - 1;
            }
            sProp = Utils.trimQuotes((String)fullText.substring(startProp, endProp));
        }
        return sProp;
    }

    private String getBundleBasename(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            String bundleProp = this.getDocument().get(region.getOffset(), region.getLength());
            String[] prefixes = this.getLoadBundleTagPrefixes(region);
            if (prefixes == null) {
                return null;
            }
            ArrayList<Element> lbTags = new ArrayList<Element>();
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                NodeList list = xmlDocument.getElementsByTagName(String.valueOf(prefix) + ":loadBundle");
                int i = 0;
                while (list != null && i < list.getLength()) {
                    Element el = (Element)list.item(i);
                    int end = Utils.getValueEnd((Node)el);
                    if (end >= 0 && end < region.getOffset()) {
                        lbTags.add(el);
                    }
                    ++i;
                }
                ++n2;
            }
            int i = 0;
            while (i < lbTags.size()) {
                Element el = (Element)lbTags.get(i);
                Attr var = el.getAttributeNode("var");
                if (bundleProp.startsWith(var.getValue() + ".") || bundleProp.startsWith(var.getValue() + "['") || bundleProp.equals(var.getValue())) {
                    String string = el.getAttributeNode("basename").getNodeValue();
                    return string;
                }
                ++i;
            }
            String bundleVar = bundleProp;
            if (bundleVar.indexOf(46) >= 0) {
                bundleVar = bundleVar.substring(0, bundleVar.indexOf(46));
            }
            if (bundleVar.indexOf("['") >= 0) {
                bundleVar = bundleVar.substring(0, bundleVar.indexOf("['"));
            }
            XModel xmodel = smw.getXModel();
            List list2 = WebPromptingProvider.getInstance().getList(xmodel, "jsf.registered.bundles", null, new Properties());
            if (list2 == null || list2.size() < 1) {
                return null;
            }
            Map map = (Map)list2.get(0);
            String string = (String)map.get(bundleVar);
            return string;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    protected String[] getLoadBundleTagPrefixes(IRegion region) {
        TaglibManagerWrapper tmw = new TaglibManagerWrapper();
        tmw.init(this.getDocument(), region.getOffset());
        if (tmw.exists()) {
            return new String[]{tmw.getCorePrefix()};
        }
        VpeTaglibManager taglibManager = this.getTaglibManager();
        if (taglibManager == null) {
            return null;
        }
        TaglibData[] data = taglibManager.getTagLibs().toArray(new TaglibData[0]);
        ArrayList<String> prefixes = new ArrayList<String>();
        int i = 0;
        while (i < data.length) {
            if ("http://java.sun.com/jsf/core".equals(data[i].getUri())) {
                prefixes.add(data[i].getPrefix());
            }
            ++i;
        }
        return null;
    }

    private VpeTaglibManager getTaglibManager() {
        IEditorPart editor = JSFExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof VpeTaglibManagerProvider) {
            return ((VpeTaglibManagerProvider)editor).getTaglibManager();
        }
        return null;
    }

    private String getPageLocale(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            String[] prefixes = this.getLoadBundleTagPrefixes(region);
            if (prefixes == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return null;
            }
            Element el = ((Attr)n).getOwnerElement();
            Element jsfCoreViewTag = null;
            String[] stringArray = prefixes;
            int n2 = prefixes.length;
            int n3 = 0;
            while (n3 < n2) {
                String prefix = stringArray[n3];
                String nodeToFind = String.valueOf(prefix) + PREFIX_SEPARATOR + VIEW_TAGNAME;
                while (el != null) {
                    if (nodeToFind.equals(el.getNodeName())) {
                        jsfCoreViewTag = el;
                        break;
                    }
                    Node parent = el.getParentNode();
                    Element element = el = parent instanceof Element ? (Element)parent : null;
                }
                ++n3;
            }
            if (jsfCoreViewTag == null || !jsfCoreViewTag.hasAttribute(LOCALE_ATTRNAME)) {
                return null;
            }
            String locale = Utils.trimQuotes((String)jsfCoreViewTag.getAttributeNode(LOCALE_ATTRNAME).getValue());
            if (locale == null || locale.length() == 0) {
                return null;
            }
            String string = locale;
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = JSPBundleHyperlinkPartitioner.getRegion(this.getDocument(), offset);
        return this.fLastRegion;
    }

    protected String getRequestMethod() {
        return "jsf.open.key";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getBundleBasename(region);
        if (value != null) {
            p.put("bundle", value);
        }
        if ((value = this.getBundleProperty(region)) != null) {
            p.put("key", value);
        }
        if ((value = this.getPageLocale(region)) != null) {
            p.setProperty(LOCALE_ATTRNAME, value);
        }
        return p;
    }

    public String getHyperlinkText() {
        String baseName = this.getBundleBasename(this.fLastRegion);
        String propertyName = this.getBundleProperty(this.fLastRegion);
        if (baseName == null || propertyName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.BundleProperty);
        }
        return MessageFormat.format(Messages.OpenBundleProperty, propertyName, baseName);
    }
}

