/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.hyperlink.JSPForwardHyperlinkPartitioner;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class ForwardHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        String fileName = this.getFilePath(region);
        IFile fileToOpen = this.getFileToOpen(fileName);
        if (fileToOpen != null && fileToOpen.exists()) {
            IWorkbenchPage workbenchPage = JSFExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)fileToOpen, (boolean)true);
            }
            catch (CoreException coreException) {
                this.openFileFailed();
            }
        } else {
            this.openFileFailed();
        }
    }

    private String getFilePath(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private IFile getFileToOpen(String fileName) {
        List list;
        IFile documentFile = this.getFile();
        XModel xModel = ForwardHyperlink.getXModel((IFile)documentFile);
        if (xModel != null && (list = WebPromptingProvider.getInstance().getList(xModel, "jsf.get.path", fileName, null)) != null && list.size() > 0) {
            for (Object o : list) {
                if (!(o instanceof String)) continue;
                fileName = (String)o;
                break;
            }
        }
        return super.getFileFromProject(fileName);
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = JSPForwardHyperlinkPartitioner.getRegion(this.getDocument(), offset);
        return this.fLastRegion;
    }

    public String getHyperlinkText() {
        String filePath = this.getFilePath(this.fLastRegion);
        if (filePath == null) {
            return MessageFormat.format(Messages.OpenA, Messages.File);
        }
        return MessageFormat.format(Messages.OpenFile, filePath);
    }
}

