/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JSPBundleHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSP_BUNDLE_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_BUNDLE";

    protected String getPartitionType() {
        return JSP_BUNDLE_PARTITION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            if (!this.recognize(document, superRegion)) {
                return null;
            }
            IHyperlinkRegion r = JSPBundleHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType();
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > end || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '[' && sb.charAt(bStart) != ']' && sb.charAt(bStart) != '\'') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '[' && sb.charAt(bEnd) != ']' && sb.charAt(bEnd) != '\'') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            IHyperlinkRegion r = JSPBundleHyperlinkPartitioner.getRegion(document, region.getOffset());
            if (r == null) {
                return false;
            }
            String bundleProp = document.get(r.getOffset(), r.getLength());
            int dotIndex = bundleProp.indexOf(".");
            int bracketIndex = bundleProp.indexOf("[");
            boolean useDot = false;
            boolean useBracket = false;
            if (dotIndex != -1) {
                useDot = true;
            }
            if (bracketIndex != -1 && (!useDot || useDot && dotIndex > bracketIndex)) {
                useBracket = true;
            }
            if (useDot && bundleProp.indexOf(".", dotIndex + 1) != -1) {
                useDot = false;
            }
            if (!useDot && !useBracket) {
                return false;
            }
            String sVar = null;
            String sProp = null;
            if (useDot) {
                sVar = bundleProp.substring(0, dotIndex);
                sProp = bundleProp.substring(dotIndex + 1);
            }
            if (useBracket) {
                sVar = bundleProp.substring(0, bracketIndex);
                int startProp = bracketIndex + 1;
                int endProp = bundleProp.indexOf("]");
                if (endProp == -1) {
                    endProp = bundleProp.length() - 1;
                }
                sProp = Utils.trimQuotes((String)bundleProp.substring(startProp, endProp));
            }
            if (sVar == null || sProp == null) {
                return false;
            }
            String[] prefixes = this.getLoadBundleTagPrefixes(document, region.getOffset());
            if (prefixes == null) {
                return false;
            }
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                ArrayList<Element> lbTags = new ArrayList<Element>();
                NodeList list = xmlDocument.getElementsByTagName(String.valueOf(prefix) + ":loadBundle");
                int i = 0;
                while (list != null && i < list.getLength()) {
                    Element el = (Element)list.item(i);
                    int end = Utils.getValueEnd((Node)el);
                    if (end >= 0 && end < region.getOffset()) {
                        lbTags.add(el);
                    }
                    ++i;
                }
                Element lbTag = null;
                int i2 = 0;
                while (i2 < lbTags.size()) {
                    Element el = (Element)lbTags.get(i2);
                    Attr var = el.getAttributeNode("var");
                    if (sVar.equals(var.getValue())) {
                        lbTag = el;
                        break;
                    }
                    ++i2;
                }
                if (lbTag != null) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    protected String[] getLoadBundleTagPrefixes(IDocument document, int offset) {
        TaglibManagerWrapper tmw = new TaglibManagerWrapper();
        tmw.init(document, offset);
        if (!tmw.exists()) {
            return null;
        }
        return new String[]{tmw.getCorePrefix()};
    }
}

