/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IExclusiblePartitionerRecognition;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.web.kb.PageContextFactory;

public class JSPExprHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer,
IExclusiblePartitionerRecognition {
    public static final String JSP_EXPRESSION_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_EXPRESSION";
    public static final String EXPRESSION_PARTITION = "org.jboss.tools.common.text.ext.jsp.EXPRESSION";
    public static final String DOT_EXPRESSION_PARTITION = "org.jboss.tools.common.text.ext.jsp.DOT_EXPRESSION";
    private static final String DOT = ".";
    private boolean jspExpression = false;
    private boolean dotExpression = false;

    protected String getPartitionType() {
        if (this.dotExpression) {
            return DOT_EXPRESSION_PARTITION;
        }
        if (this.jspExpression) {
            return EXPRESSION_PARTITION;
        }
        return JSP_EXPRESSION_PARTITION;
    }

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        IHyperlinkRegion r = this.getRegion(document, superRegion.getOffset());
        if (r == null) {
            return null;
        }
        String axis = this.getAxis(document, superRegion);
        String contentType = superRegion.getContentType();
        String type = this.getPartitionType();
        int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
        int offset = superRegion.getOffset();
        HyperlinkRegion region = new HyperlinkRegion(offset, length, axis, contentType, type);
        return region;
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    private IHyperlinkRegion getRegion(IDocument document, int offset) {
        ExpressionStructure eStructure;
        this.jspExpression = false;
        this.dotExpression = false;
        ELContext context = JSPExprHyperlinkPartitioner.getELContext(document);
        if (context != null && (eStructure = JSPExprHyperlinkPartitioner.getExpression(context, offset)) != null) {
            ELInvocationExpression invocationExpression = JSPExprHyperlinkPartitioner.getInvocationExpression(eStructure.reference, eStructure.expression, offset);
            if (invocationExpression != null) {
                this.jspExpression = this.decide(context, eStructure.expression, invocationExpression, offset - eStructure.reference.getStartPosition(), offset);
                if (this.jspExpression) {
                    HyperlinkRegion region = new HyperlinkRegion(invocationExpression.getStartPosition(), invocationExpression.getLength(), null, null, null);
                    return region;
                }
            }
            this.dotExpression = this.checkDot(document, offset, context, eStructure.expression, invocationExpression, offset - eStructure.reference.getStartPosition());
            HyperlinkRegion region = new HyperlinkRegion(eStructure.expression.getStartPosition(), eStructure.expression.getLength(), null, null, null);
            return region;
        }
        return null;
    }

    public static ExpressionStructure getExpression(ELContext context, int offset) {
        ELReference[] references;
        ELReference[] eLReferenceArray = references = context.getELReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            ELReference reference = eLReferenceArray[n2];
            ELExpression[] eLExpressionArray = reference.getEl();
            int n3 = eLExpressionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ELExpression expression = eLExpressionArray[n4];
                if (reference.getStartPosition() + expression.getStartPosition() <= offset && reference.getStartPosition() + expression.getEndPosition() > offset) {
                    return new ExpressionStructure(reference, expression);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static ELContext getELContext(IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            ELContext context;
            IFile file = smw.getFile();
            PageContextFactory.getInstance();
            ELContext eLContext = context = PageContextFactory.createPageContext((IFile)file);
            return eLContext;
        }
        finally {
            smw.dispose();
        }
    }

    public static ELInvocationExpression getInvocationExpression(ELReference reference, ELExpression expression, int offset) {
        if (expression == null || reference == null) {
            return null;
        }
        for (ELInvocationExpression ie : expression.getInvocations()) {
            if (reference.getStartPosition() + ie.getStartPosition() > offset || reference.getStartPosition() + ie.getEndPosition() <= offset) continue;
            return ie;
        }
        return null;
    }

    public boolean decide(ELContext context, ELExpression expression, ELInvocationExpression invocationExpression, int offset, int globalOffset) {
        ELResolver[] eLResolverArray = context.getElResolvers();
        int n = eLResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMemberELSegment javaSegment;
            ELResolver resolver = eLResolverArray[n2];
            ELResolution resolution = resolver.resolve(context, (ELExpression)invocationExpression, globalOffset);
            if (resolution == null) {
                return false;
            }
            ELSegment segment = resolution.findSegmentByOffset(offset);
            if (segment != null && segment.isResolved() && segment instanceof JavaMemberELSegment && (javaSegment = (JavaMemberELSegment)segment).getJavaElement() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean checkDot(IDocument document, int superOffset, ELContext context, ELExpression expression, ELInvocationExpression invocationExpression, int offset) {
        block4: {
            block5: {
                String text = document.get(superOffset, 1);
                if (!DOT.equals(text)) break block4;
                if (!this.decide(context, expression, invocationExpression, offset + 1, superOffset + 1)) break block5;
                return true;
            }
            try {
                if (this.decide(context, expression, invocationExpression, offset - 1, superOffset - 1)) {
                    return true;
                }
            }
            catch (BadLocationException ex) {
                JSFExtensionsPlugin.log((Exception)((Object)ex));
            }
        }
        return false;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (document == null || region == null) {
            return false;
        }
        return this.getRegion(document, region.getOffset()) != null;
    }

    public boolean excludes(String partitionType, IDocument document, IHyperlinkRegion superRegion) {
        return false;
    }

    public String getExclusionPartitionType() {
        return this.getPartitionType();
    }

    public static class ExpressionStructure {
        public ELReference reference;
        public ELExpression expression;

        public ExpressionStructure(ELReference reference, ELExpression expression) {
            this.reference = reference;
            this.expression = expression;
        }
    }
}

